#include <xvinclude.h>

/*
 * This program puts up a list.  An callback allows the user to 
 * quit the program by double clicking on one of the list items.
 * The call_data structure is used to retrieve the user's selection.
 */

static void quit_program PROTO((xvobject, kaddr, kaddr));

static char *colors[] =
{
        "magenta",   "yellow", "blue",   "orange",    "coral",
        "orange",    "wheat",  "lime",   "turquoise", "pink",
        "lightgrey", "plum",   "forest", "red",       "salmon",
        "thistle",   "violet", "orangered", "seagreen",
};

main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent; 
	xvobject list; 
	xvobject actual_list;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create the manager object backplane */
	parent = xvw_create_manager(NULL, "manager");
        xvw_set_attributes(parent,
		XVW_WIDTH,  150,
		XVW_HEIGHT, 250,
		NULL);

	/*
 	 *  create the list object.  give it a minimum width & height,
         *  and set the contents of the list using xvw_change_list().
	 */
        list = xvw_create_list(parent, "list");
	xvw_set_attribute(list, XVW_TACK_EDGE, KMANAGER_TACK_ALL);

	/*
         * the list is a compound object; need to get the actual list 
         * object to set the contents (also see examples/xvwidgets/02.lists).
         */
	actual_list = xvw_retrieve_list(list);
	xvw_change_list(actual_list, colors, knumber(colors), FALSE);

	/* 
	 * Add the callback to quit the program when the user
         * double clicks on a list item (XVW_LIST_ITEM_ACTION).
         * Note that if the callback was to fire on a single click,
         * we would use XVW_LIST_ITEM_SELECT instead.  Note that the
         * callback is added on the actual_list.
         */
	xvw_add_callback(actual_list, XVW_LIST_ITEM_ACTION, 
		         quit_program, NULL);

	/* display and run */
        xvf_run_form();
}

/*
 *  callback to quit program on double click
 */
static void  quit_program(
   xvobject object,       /* the list visual object */
   kaddr    client_data,  /* not used */ 
   kaddr    call_data)    /* list object will pass in an xvw_list_struct */
{
        xvw_list_struct *list_return;

        /*
         * a list object is one of the few objects that uses a call_data
         * structure.  it needs to => return information to the caller,
         * so that information is returned via the call_data.  The data type
         * of the call_data is determined by the object itself;  a list
         * object uses a call_data of type "xvw_list_struct".  The
         * xvw_list_struct data structure has two fields: a char *string,
         * and an int list_index.
         */
        list_return = (xvw_list_struct *) call_data;

        /*
         * use contents of call_data structure to display index & string
         */
        kfprintf(kstderr, "Chosen was item %d of the list, %s\n",
                 list_return->list_index, list_return->string);

        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}
