#include "dataserv.h"

#define FAIL(error)               \
        {                         \
          kinfo(KFORCE,error);    \
          kexit(KEXIT_FAILURE);   \
        }

main()
{
   kobject i;
   kobject o;
   int j;
   int k;
   int *size;
   int *order;
   unsigned char *data = NULL;
   int begin[5] = {0, 0, 0, 0, 0};
   int end[5] = {2, 0, 0, 0, 0};
   
   if ((i = kdms_input("$DATASERV/data/testdata/20x20.bit.xbm")) == NULL)
      FAIL("can not open the data set");

   if ((o = kdms_output("test.viff")) == NULL)
      FAIL("can not open the output data set.");
   
   kdms_get_attributes(i, KDMS_SEGMENT_VALUE, KDMS_SIZE, &size,
		       KDMS_INDEX_ORDER, &order, NULL);

   kdms_create_segment(o, KDMS_SEGMENT_VALUE);
   
   kdms_set_attributes(o, KDMS_SEGMENT_VALUE, KDMS_DIMENSION, 5, 
		       KDMS_SIZE, size,
		       KDMS_INDEX_ORDER, order,
		       KDMS_DATA_TYPE, KBIT, 
		       NULL);
   
   kprintf("size = (%d %d %d %d %d)\n", size[0], size[1], size[2], size[3],
	   size[4]);

   for (k = 0; k < size[1]; k++, begin[1]++, end[1]++)
   {
      kprintf("%.2d -> ", k);
      for (j = 0; j < size[0] / 3; j++, begin[0]+=3,end[0]+=3)
      {
	 data = kdms_get_data(i, KDMS_SEGMENT_VALUE, begin, end, data);
	 kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data);
	 kprintf("%x ", data[0] >> 5);
      }
      kprintf("\n");
      
      begin[0] = 0;
      end[0] = 2;
   }

   kprintf("\n");
   
   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[1] = end[2] = end[3] = end[4] = 0;
   end[0] = 2;
   
   for (k = 0; k < size[1]; k++, begin[1]++, end[1]++)
   {
      kprintf("%.2d -> ", k);
      for (j = 0; j < size[0] / 3; j++, begin[0]+=3,end[0]+=3)
      {
	 data = kdms_get_data(o, KDMS_SEGMENT_VALUE, begin, end, data);
	 kprintf("%x ", data[0] >> 5);
      }
      kprintf("\n");
      
      begin[0] = 0;
      end[0] = 2;
   }

   kdms_close(i);
   kdms_close(o);
} 
