 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Geometry Application Services
   >>>>            	Segment Routines 
   >>>>   Static:
   >>>>			_create_color()  
   >>>>			_create_normal()  
   >>>>			_create_texture_coord()  
   >>>>			_create_radius()  
   >>>>  Private:
   >>>>			kgeom_init_segments()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "geom_internals.h"

/*-----------------------------------------------------------
|
|  Routine Name: (static) _create_color
|
|       Purpose: This routine will create the color segment and
|		 initialize its dimensionality and index order.
|
|         Input: obj     - the obj in which to create the 
|			   color segment
|		 segment - the name of the color segment
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 01, 1994 16:23
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int
_create_color(
   kobject  obj,
   char    *segment)
{
   int order[KGEOM_COLOR_DIM] = {KELEMENTS, KWIDTH, KHEIGHT, KDEPTH};

   if (!kdms_create_segment(obj, KGEOM_SEGMENT_COLOR))
      return FALSE;
   
   if (!kdms_set_attributes(obj, KGEOM_SEGMENT_COLOR, 
			    KDMS_DIMENSION,   KGEOM_COLOR_DIM,
			    KDMS_INDEX_ORDER, order, 
			    NULL))
      return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _create_normal
|
|       Purpose: This routine will create the normal segment and
|		 initialize its dimensionality and index order.
|
|         Input: obj     - the obj in which to create the 
|			   normal segment
|		 segment - the name of the normal segment
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 01, 1994 16:23
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int
_create_normal(
   kobject  obj,
   char    *segment)
{
   int order[KGEOM_NORMAL_DIM] = {KELEMENTS, KWIDTH, KHEIGHT, KDEPTH};

   if (!kdms_create_segment(obj, KGEOM_SEGMENT_NORMAL))
      return FALSE;
   
   if (!kdms_set_attributes(obj, KGEOM_SEGMENT_NORMAL, 
			    KDMS_DIMENSION,   KGEOM_NORMAL_DIM,
			    KDMS_INDEX_ORDER, order, 
			    NULL))
      return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _create_texture_coord
|
|       Purpose: This routine will create the texture coord 
|		 segment and initialize its dimensionality
|		 and index order.
|
|         Input: obj     - the obj in which to create the 
|			   texture coord segment
|		 segment - the name of the texture coord 
|			   segment
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 01, 1994 16:23
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int
_create_texture_coord(
   kobject  obj,
   char    *segment)
{
   int order[KGEOM_TEXTURE_COORD_DIM] = {KELEMENTS, KWIDTH, KHEIGHT, KDEPTH};

   if (!kdms_create_segment(obj, KGEOM_SEGMENT_TEXTURE_COORD))
      return FALSE;
   
   if (!kdms_set_attributes(obj, KGEOM_SEGMENT_TEXTURE_COORD, 
			    KDMS_DIMENSION,   KGEOM_TEXTURE_COORD_DIM,
			    KDMS_INDEX_ORDER, order, 
			    NULL))
      return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _create_radius
|
|       Purpose: This routine will create the radius segment and
|		 initialize its dimensionality and index order.
|
|         Input: obj     - the obj in which to create the 
|			   radius segment
|		 segment - the name of the radius segment
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 01, 1994 16:23
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int
_create_radius(
   kobject  obj,
   char    *segment)
{
   int order[KGEOM_RADIUS_DIM] = {KELEMENTS, KWIDTH};

   if (!kdms_create_segment(obj, KGEOM_SEGMENT_RADIUS))
      return FALSE;
   
   if (!kdms_set_attributes(obj, KGEOM_SEGMENT_RADIUS, 
			    KDMS_DIMENSION,   KGEOM_RADIUS_DIM,
			    KDMS_INDEX_ORDER, order, 
			    NULL))
      return FALSE;

   return TRUE;
}

/* 
 *    ================================================================== 
 *    PRIVATE SEGMENT functions
 *    ==================================================================
 */

/*-----------------------------------------------------------
|
|  Routine Name: kgeom_define_segments()
|
|       Purpose: Define the color, normal, texture coord, and radius 
|		 segment.
|
|         Input: none
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Dec 26, 1994
| Modifications:
|
------------------------------------------------------------*/
int
kgeom_define_segments(void)
{
   int status = TRUE;

   status &= kdms_define_segment(KGEOM_SEGMENT_COLOR, _create_color,
				 NULL, NULL, NULL, NULL, 
				 NULL, NULL, NULL, NULL, NULL, NULL);

   status &= kdms_define_segment(KGEOM_SEGMENT_NORMAL, _create_normal,
				 NULL, NULL, NULL, NULL, 
				 NULL, NULL, NULL, NULL, NULL, NULL);

   status &= kdms_define_segment(KGEOM_SEGMENT_TEXTURE_COORD, 
				 _create_texture_coord,
				 NULL, NULL, NULL, NULL, 
				 NULL, NULL, NULL, NULL, NULL, NULL);

   status &= kdms_define_segment(KGEOM_SEGMENT_RADIUS, _create_radius,
				 NULL, NULL, NULL, NULL, 
				 NULL, NULL, NULL, NULL, NULL, NULL);
   return status;
}
