 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgdbm_dump
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgdbm_dump.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Print Out GDBM File
|
|       Purpose: main program for kgdbm_dump
|
|         Input:
|		char *clui_info->i_file; {Input data base to print information for}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->n_int; {Number of Points to Print}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		int clui_info->all_flag; {TRUE if -all specified}
|
|		char *clui_info->key_string; {Key to be printed, otherwise all keys are dumped}
|		int   clui_info->key_flag; {TRUE if -key specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kdbm *dbm;
        kdatum key, data;
        int j, size;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATASERV");
	kexit_handler(kgdbm_dump_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATASERV", "kgdbm_dump",
		kgdbm_dump_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgdbm_dump_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((dbm = kdbm_open(clui_info->i_file, KOPEN_RDONLY, 0666)) == NULL)
        {
           kerror(NULL, "kgdbm_dump",
                 "Failed to open database '%s'", clui_info->i_file);
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!clui_info->key_flag)
	{
           for (key = kdbm_firstkey(dbm); key.dptr != NULL;
                key = kdbm_nextkey(dbm))
           {
              data = kdbm_fetch(dbm, key);
              kfprintf(kstdout,"[%s]: \n", key.dptr);
 
              if (clui_info->all_flag) 
                  size = data.dsize;
              else
                  size = clui_info->n_int;

              if (size >= data.dsize)
                 size = data.dsize;

              if (size > 0)
              {
                 kfprintf(kstdout,"    ");
                 for (j = 0; j < size; j++)
                 {
                    kfprintf(kstdout,"%.2x ",data.dptr[j]);
                    if ((j+1)%20 == 0) kfprintf(kstdout,"\n    ");
                 }

                 kfprintf(kstdout,"\n    ** [PRINTED %i OF %i TOTAL] ** \n", 
 			      size, data.dsize);
              }
           }
	}
	else
	{
	   key.dptr = clui_info->key_string;
	   key.dsize = kstrlen(key.dptr) + 1;

           data = kdbm_fetch(dbm, key);
           kfprintf(kstdout,"[%s]: \n", key.dptr);
 
           if (clui_info->all_flag) 
               size = data.dsize;
           else
               size = clui_info->n_int;

           if (size >= data.dsize)
               size = data.dsize;

           if (size > 0)
           {
               kfprintf(kstdout,"    ");
               for (j = 0; j < size; j++)
               {
                  kfprintf(kstdout,"%.2x ",data.dptr[j]);
                  if ((j+1)%20 == 0) kfprintf(kstdout,"\n    ");
               }

               kfprintf(kstdout,"\n    ** [PRINTED %i OF %i TOTAL] ** \n", 
 			   size, data.dsize);
           }
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	kfprintf(kstdout,"\n");
        kdbm_close(dbm);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgdbm_dump_usage_additions
| 
|       Purpose: Prints usage additions in kgdbm_dump_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgdbm_dump
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgdbm_dump_usage_additions(void)
{
	kfprintf(kstderr, "\tPrint Out GDBM File\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgdbm_dump_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgdbm_dump_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgdbm_dump
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgdbm_dump_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->key_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
