 /*  
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  To provide function declarations and
   >>>>			definitions for the kdataserv library.
   >>>>                 
   >>>>			The Data Management Services provides 
   >>>>                 the programmer with an interface to a
   >>>>                 powerful data abstraction and manipulation.
   >>>>
   >>>>    Written By: Mark Young, Jeremy Worley, Steve Kubica
   >>>>
   >>>>          Date: Aug 17, 1992 13:03
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kdataman_kdataman_h_
#define _kdataman_kdataman_h_


        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/

        /*-------------------------------------*
        |       #defines 
        ---------------------------------------*/

/*
 * maximum dimension supported currently
 */
#define KDMS_MAX_DIM 5


/*
 * File Format Definitions
 */
#define KVIFF           "viff"
#define KXVIMAGE        "xvimage"
#define KPNM            "pnm"
#define KRASTER         "rast"
#define KAVS            "avs"
#define KXBM            "xbm"
#define KXPM            "xpm"
#define KXWD            "xwd"
#define KARF            "arf"
#define KEPS            "eps"
#define KASCII          "ascii"
#define KRAW            "raw"

/*
 * File declaration definitions
 */
#define KOBJ_READ       0x1
#define KOBJ_WRITE      0x2
#define KOBJ_STREAM     0x8000
#define KOBJ_HEADERLESS 0x4000
#define KOBJ_RAW        KOBJ_HEADERLESS

/*
 * Meta attributes
 */
#define KUNCOUPLED 0
#define KDEMAND 1
#define KCOUPLED 2

#define KPRES2PHYS 1
#define KPHYS2PRES 2

/*
 * Raggedness
 */
#define KDMS_RAGGED 1
#define KDMS_FIXED  2

/*
 * Segments
 */
#define KDMS_OBJECT			NULL
#define KDMS_ALL_SEGMENTS		"AllSegments"
#define KDMS_SEGMENT_VALUE		"value"
#define KDMS_SEGMENT_MAP		"map"
#define KDMS_SEGMENT_MASK		"mask"
#define KDMS_SEGMENT_LOCATION		"location"
#define KDMS_SEGMENT_WIDTH  		"width"
#define KDMS_SEGMENT_HEIGHT 		"height"
#define KDMS_SEGMENT_DEPTH  		"depth"
#define KDMS_SEGMENT_TIME		"time"
#define KDMS_SEGMENT_LOCATION_MINIMUM 	"locationMinimum"
#define KDMS_SEGMENT_LOCATION_MAXIMUM 	"locationMaximum"

/*
 * Callback defines
 */
#define KDMS_CALLBACK_CHANGE "DMSChangeCallback"
#define KDMS_CALLBACK_ACCESS "DMSAccessCallback"
#define KDMS_CALLBACK_DELETE "DMSDeleteCallback"
#define KDMS_CALLBACK_SAVE   "DMSSaveCallback"

/*
 * Object
 */
#define KOBJECT_INVALID		NULL

/*
 * Things associated with KDMS_COMPLEX_CONVERT
 *
 * see the defines in kmath/kdata.h for:
 *
 *		KNONE
 *		KREAL
 *		KIMAGINARY
 *		KPHASE
 *		KMAGNITUDE
 */

/*
 * Things associated with KDMS_INTERPOLATE
 *
 * see the defines in kmath/kdata.h for:
 *
 *		KNONE
 *		KPAD
 *		KZERO_ORDER
 *		KFIRST_ORDER
 */

/*
 * Things associated with KDMS_DOWNCAST
 *
 * see the defines in kmath/kdata.h for:
 *
 *		KNONE
 *		KCAST
 *		KSCALE
 *		KNORMALIZE
 */

/*
 * Things associated with dimensions, positions and KDMS_MAP_SCHEME
 */
#define KINVALID_DIRECTION	0

#define KONE			1
#define KWIDTH			2
#define KHEIGHT			3
#define KDEPTH			4
#define KTIME			5
#define KELEMENTS		6

/* these are currently used internally */
#define KDIMENSION		KTIME
#define KMAP_WIDTH		KWIDTH
#define KMAP_HEIGHT		KHEIGHT
#define KMAP_ELEMENTS		KDEPTH
#define KMAP_DEPTH		KTIME
#define KMAP_TIME		KELEMENTS

/*
 * Things associated with KDMS_MAP_ENABLE
 */
#define KOPTIONAL 0 /* default */
#define KFORCED	  1

/*
 * Transient Attributes
 */
/*------------------------------------------------------------------------
| Attribute:	KDMS_FLAGS
| Type:		int flags
| Default:      KNONE
| Category:     global
| Legal Values: KOBJ_READ
|               KOBJ_WRITE
|		KOBJ_STREAM
|		KOBJ_HEADERLESS
|		KOBJ_RAW
| Description:	This attribute returns the flags used when opening the
|		data object.
|		.symbol index kdms_input
|		automatically sets
|		.symbol index KOBJ_READ
|		and
|		.symbol index kdms_output
|		automatically sets
|		.symbol index KOBJ_WRITE
|		when called.
|		When used in
|		.symbol index kdms_open ,
|		the legal values can be OR'd together to change the behavior
|		of the object.  For example, ORing together 
|		.symbol noindex KOBJ_READ
|		and
|		.symbol noindex KOBJ_RAW
|		together will cause unrecognized files to be read in as raw
|		data.  This attribute is available so that a process can 
|		customize its interaction with an object based on how it
|		was opened.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_FLAGS                      "dms_flags"

/*------------------------------------------------------------------------
| Attribute:	KDMS_SCALING
| Type:		int scaling
| Default:      KNONE
| Category:     segment
| Legal Values: KNONE
|               KNORMALIZE
|               KSCALE
| Description:	This attribute specifies whether scaling or normalization should be
|               performed.
|               .br
|               If
|		.symbol index KSCALE 
|		is specified for a segment,
|		data values from that segment will be
|               scaled, according to the
|               .symbol index KDMS_SCALE_FACTOR
|               and
|               .symbol index KDMS_SCALE_OFFSET
|               attributes.  If 
|		.symbol index KNORMALIZE 
|		is specified for a segment, 
|		data values from that segment will be normalized using the
|               .symbol index KDMS_NORM_MIN
|               and
|               .symbol index KDMS_NORM_MAX
|               attributes.  If this attribute is set to 
|		.symbol index KNONE 
|		for the a segment,
|               data values from that segment will not be scaled or normalized.  
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_SCALING			"dms_scaling"

/*------------------------------------------------------------------------
| Attribute:	KDMS_COUPLING
| Type:		int coupling
| Default:      See Note 1.
| Category:     global
| Legal Values: KCOUPLED
|               KDEMAND
|               KUNCOUPLED
| Description:	When this attribute is set to 
|		.symbol index KCOUPLED , 
|		changes to any 
|		attribute that affects the physical representation of the 
|		data (for example, data type, size, etc.) will be 
|		propagated to the physical layer immediately. Otherwise, 
|		the presentation layer is the only layer that is changed,
|		--the physical layer remains unchanged.  The difference 
|		between 
|		.symbol index KUNCOUPLED 
|		and 
|		.symbol index KDEMAND 
|		is that 
|		.symbol index KDEMAND 
|		allows the
|		.symbol index kdms_sync()
|		function call to force an update
|		of the presentation and physical layers.  When this 
|		attribute is set to 
|		.symbol index KUNCOUPLED , 
|		the calling the
|               .symbol index kdms_sync() 
|		will not do anything.  See
|               .symbol index kdms_sync()
|		for more information.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_COUPLING			"dms_coupling"

/*------------------------------------------------------------------------
| Attribute:	KDMS_COMPLEX_CONVERT
| Type:		int convert
| Default:      KREAL
| Category:     segment
| Legal Values: KIMAGINARY
|               KMAGNITUDE
|               KPHASE
|               KREAL
|		KMAGSQ
|		KMAGSQP1
|		KLOGMAG
|		KLOGMAGP1
| Description:	This attribute specifies how complex data should be 
|		converted.  If it is converted to a "lower" data type,
|               this attribute specifies how to down-convert the data.
|               For example if the data is actually complex, but the 
|		presentation attribute is byte, the complex data would 
|		first be converted to the representation defined by 
|		this attribute, and then converted to byte.  
|               .br
|               If the data is being converted from a "lower" data type
|		to a complex data type, this attribute defines how the
|		data should be interpreted \*- as the real or imaginary 
|		component of the complex pair.  
|		.symbol index KPHASE
|		and 
|		.symbol index KMAGNITUDE
|		are invalid values for up converting
|		to complex, and will result in an error.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_COMPLEX_CONVERT		"dms_complex_convert"

/*------------------------------------------------------------------------
| Attribute:	KDMS_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     segment
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Description:	This attribute specifies how the data should be         
|               presented if the application program requests a size    
|		different from what is physically stored. If the size   
|		requested is larger than the physical size and the      
|               interpolation requested is 
|		.symbol index KPAD
|		the pad value   
|               will be returned for all points outside of the physical 
|               size.  If the size requested is smaller than the        
|               physical size and the interpolation requested is        
|               .symbol index KPAD 
|		the returned data is clipped to the size   
|               requested.  If the size requested is larger than the    
|               physical size and the interpolation requested is        
|               .symbol index KZERO_ORDER
|		the data is duplicated.  If the size
|               requested is smaller than the physical size and the     
|               interpolation requested is 
|		.symbol index KZERO_ORDER
|		the data 
|               is sub-sampled.  If the interpolate attribute is set to 
|               .symbol index KNONE , 
|		an error will be returned if the program 
|		requests a size different from what is physically       
|		stored.                                                 
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_INTERPOLATE		"dms_interpolate"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PAD_VALUE
| Type:		double real, imag
| Default:      0.0, 0.0
| Category:     segment
| Legal Values: 
| Description:	This attribute specifies the real (and imaginary) values of the pad
|               data if the 
|		.symbol noindex KDMS_INTERPOLATE 
|		attribute is set to 
|		.symbol index KPAD ,
|               respectively.  The double values must be specified, whether the data
|               is real or complex.  The pad values will internally be converted from
|               double to the appropriate data type.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_PAD_VALUE			"dms_pad_value"

/*------------------------------------------------------------------------
| Attribute:	KDMS_NORM_MAX
| Type:		double norm_max
| Default:      
| Category:     segment
| Legal Values: > norm_min
| Description:	This attribute specifies the maximum to be used when 
|		normalizing data values.  This attribute is used in 
|		conjunction with the 
|		.symbol noindex KDMS_NORM_MIN 
|		attribute, 
|		respectively, to determine the bounds of a normalization
|               operation.  This attribute comes into play when the 
|		.symbol noindex KDMS_SCALING 
|		attribute is set to 
|		.symbol index KNORMALIZE .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_NORM_MIN			"dms_norm_min"

/*------------------------------------------------------------------------
| Attribute:	KDMS_NORM_MIN
| Type:		double norm_min
| Default:      unknown
| Category:     segment
| Legal Values: < norm_max
| Description:	This attribute specifies the minimum to be used when 
|		normalizing data values.  This attribute is used in 
|		conjunction with the 
|		.symbol noindex KDMS_NORM_MAX 
|		attribute, 
|		respectively, to determine the bounds of a normalization
|               operation.  This attribute comes into play when the 
|		.symbol noindex KDMS_SCALING 
|		attribute is set to 
|		.symbol index KNORMALIZE .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_NORM_MAX			"dms_norm_max"

/*------------------------------------------------------------------------
| Attribute:	KDMS_SCALE_FACTOR
| Type:		double scale_factor
| Default:      1.0
| Category:     segment
| Legal Values: 
| Description:	This attribute specifies the scaling factor to be used when scaling
|               data values.  This attribute comes into play when the 
|		.symbol noindex KDMS_SCALING
|               attribute is set to 
|		.symbol index KSCALE , 
|		respectively.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_SCALE_FACTOR		"dms_scale_factor"

/*------------------------------------------------------------------------
| Attribute:	KDMS_SCALE_OFFSET
| Type:		double real, offset
| Default:      0.0, 0.0
| Category:     segment
| Legal Values: 
| Description:	This attribute specifies the scaling offset to be used when scaling
|               data values.  This attribute comes into play when the 
|		.symbol noindex KDMS_SCALING
|               attribute is set to 
|		.symbol index KSCALE , 
|		respectively.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_SCALE_OFFSET		"dms_scale_offset"

/*------------------------------------------------------------------------
| Attribute:	KDMS_OPTIMAL_REGION_SIZE
| Type:		int *sizes
| Default:      
| Category:     segment
| Legal Values: > 0
| Description:	This attribute will return the size of a region of data and the number
|               of such regions that is most efficient to process in terms of
|               performance and memory use.  The number of values in the integer
|		array is n+1, where n is the dimension of the segment.  
|		The first n entries correspond to the axes of the data set and
|		the last entry in the array is the number such regions in the
|		segment.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_OPTIMAL_REGION_SIZE        "dms_optimal_region_size"

/*------------------------------------------------------------------------
| Attribute:	KDMS_BUFFER_THRESHOLD
| Type:		int threshold
| Default:      2097152 bytes
| Category:     segment
| Legal Values: > 0
| Description:	This attribute is used to specify the largest number of bytes
|		that should be allocated for buffering data in memory.  This
|		number is used to determine the size and geometry of a buffer
|		that is used to minimize transport access.  Thus, it has 
|		a large impact on the performance of a process using 
|	        data services.   The value of this attribute is also used
|		to determine the size and geometry of the
|		.symbol index KDMS_OPTIMAL_REGION_SIZE .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_BUFFER_THRESHOLD		"dms_buffer_threshold"

/*
 * Quasi-Stored Attributes
 */

/*------------------------------------------------------------------------
| Attribute:	KDMS_NAME
| Type:		char *name
| Default:      
| Category:     global
| Legal Values: 
| Description:	This attribute is used to obtain the filename associated
|		with the specified data object.  This is that name
|		passed in to 
|		.symbol index kdms_open , 
|		.symbol index kdms_output ,
|		or 
|		.symbol index kdms_input .  
|		Objects that are instantiated with 
|		.symbol index kdms_create 
|		do not have a filename.  In such
|		instances, this attribute's value is 
|		.symbol noindex NULL .
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_NAME			"name"

/*------------------------------------------------------------------------
| Attribute:	KDMS_ARCHITECTURE
| Type:		int architecture
| Default:      
| Category:     global
| Legal Values: KMACH_UNKNOWN
|               KMACH_I80x86
|               KMACH_NS32000
|               KMACH_MIPSEL
|               KMACH_I860
|               KMACH_SPARC
|               KMACH_IBMRT
|               KMACH_RS6000
|               KMACH_POWERPC
|               KMACH_MC680x0
|               KMACH_M88x00
|               KMACH_MIPSEB
|               KMACH_PARISC
|               KMACH_CONVEX
|               KMACH_APOLLO
|               KMACH_ALPHA
|               KMACH_CYBER
|               KMACH_CRAY
|               KMACH_VAX
| Description:	This attribute is an integer value which encodes a 
|		description of the floating point and integer representation
|		for the machine which what used to generate the object.
|		A set of C defines are typically used when operating on the
|		value of this attribute in a program.  Typically, this
|		attribute is set based on an examination of the input object,
|		and is set to the local architecture on an output object.
|		The encoding scheme and specific values for these defines 
|		can be found in 
|		.symbol noindex "$BOOTSTRAP/include/machine/kmachine.h" .
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_ARCHITECTURE		"architecture"

/*------------------------------------------------------------------------
| Attribute:	KDMS_FORMAT
| Type:		char *format
| Default:      viff
| Category:     global
| Legal Values: viff
|		xvimage
|		xpm
|		xbm
|		xwd
|		pnm
|		eps
|		rast
|		avs
|		ascii
|		raw
| Description:	This attribute specifies the file format that will be
|		used with the object.  If the object is an input object,
|		then this attribute is automatically initialized to the
|		file format that the object is stored in.  If the object
|		is an output object, then this attribute defaults to 
|		"viff", indicating that the output data file will be a
|		viff.  On output objects, this attribute can be set to
|		any of the legal values.  The result is that when the
|		object is closed, it will be written out in the format
|		specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_FORMAT			"format"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PERMANENCE
| Type:		int permanence
| Default:      TRUE
| Category:     global
| Legal Values: TRUE
|		FALSE
| Description:	This attribute is used to determine if the data associated
|		with the object is coming from a transport that has permanence.
|		Permanence of a transport is defined by whether the data 
|		will exist after the process has read it.  The primary consequence
|		of a non-permanent transport is that it cannot be seeked on.
|		In otherwords, once a byte of data in such a transport has
|		been read or written, it cannot be reread or rewritten.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_PERMANENCE			"permanence"

/*
 * Stored Attributes
 */

/*------------------------------------------------------------------------
| Attribute:	KDMS_COMMENT
| Type:		char *comment
| Default:      NULL
| Category:     global
| Legal Values: 
| Description:	This attribute is a 
|		.symbol - NULL 
|		terminated string used to document
|		the object.  This attribute is used by a user or programmer
|		to describe the origin or nature of the data set.  When 
|		this attribute is set, it overwrites anything previously
|               held in this attribute.  Therefore, it is up to the 
|		programmer to first get the comment attribute, append new 
|		information to it, and then set the entire comment
|		attribute, if prior comment information is to be
|               propagated.  To clear the comment attribute, pass in 
|		.symbol - NULL
|		 when setting the attribute. This attribute is 
|		copied with the 
|		.symbol index kdms_copy_object() 
|		function calls.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_COMMENT			"comment"

/*------------------------------------------------------------------------
| Attribute:	KDMS_DATE
| Type:		char *date
| Default:      current date
| Category:     global
| Legal Values: 
| Description:	This attribute is a
|		.symbol noindex NULL
|		terminated string used to record
|		the date of the creation of the data object.  This attribute
|		is NOT copied by 
|		.symbol index kdms_copy_object() .  
|		To assign
|		the current date as defined by computer system, pass in 
|		.symbol - NULL
|		when setting the attribute.  The date will be
|		stored in the default format of the UNIX 
|		.symbol index date
|               command ("day month date HH:MM:SS timezone year", e.g. 
|		"Wed Mar 10 00:07:23 MST 1994")
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_DATE			"date"


/*------------------------------------------------------------------------
| Attribute:	KDMS_DATA_TYPE
| Type:		int datatype
| Default:      
| Category:     segment
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Description:	This attribute is used to get or set the data type, or 
|		numerical representation of the data.  This 
|		data type will be the presentation data type, not 
|		necessarily the physical data type.  See the 
|		.symbol index KDMS_COUPLING
|		attribute for more information on how to control the 
|		presentation and physical data types.  When the 
|		application programmer specifies a presentation data type
|               that is different than the actual data type of the stored
|		data, the get 
|		.symbol index kdms_get_data 
|		function will convert the data
|		to return the requested data type.  Likewise, the 
|		.symbol index kdms_put_data 
|		function expects data that is in the data 
|		type specified by this attribute to the output object, and
|		if the data being "put" is of a different type, it will be
|               converted.  This attribute must be set for objects created
|		via 
|		.symbol index kdms_create 
|		or output objects that are opened 
|		with 
|		.symbol index kpds_output 
|		or 
|		.symbol index kpds_open , 
|		or else the get and put data calls will fail.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_DATA_TYPE			"data_type"

/*------------------------------------------------------------------------
| Attribute:	KDMS_INDEX_ORDER
| Type:		int *order
| Default:      
| Category:     segment
| Legal Values: 
| Description:	This attribute specifies the ordering of indices of the
|		segment to set the orientation of how data is stored and
|		retrieved.  When the application programmer specifies a 
|		presentation index order different than the
|		actual index order of the stored data by setting this
|		attribute, the get functions will acquire the data using 
|		the presentation index order.  This attribute also dictates
|		the interpretation of the 
|		.symbol index KDMS_SIZE
|		and
|		.symbol index KDMS_OPTIMAL_REGION_SIZE
|		attributes.  For example, if the index order is 
|		.symbol noindex KWIDTH ,
|		.symbol noindex KDEPTH ,
|		.symbol noindex KHEIGHT
|		on a 3 dimensional segment, then in the size array used when
|		setting or getting the 
|		.symbol index KDMS_SIZE
|		attribute, the arguments will be width, depth, and height,
|		in that order.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_INDEX_ORDER		"index_order"

/*------------------------------------------------------------------------
| Attribute:	KDMS_SIZE
| Type:		int *size
| Default:      
| Category:     segment
| Legal Values: > 0
| Description:	This attribute specifies the size of the axes of a data
|		segment.
|               When the application programmer specifies a size larger than the
|               actual size of stored data, the get functions will sub-sampled,
|               clipped, padded or duplicated the data to present the program with the
|               requested amount, see the attribute
|               .symbol index KDMS_INTERPOLATE
|               for more details.  The put functions store exactly the size that the
|               physical attributes will allow even if the amount of data "put" (set
|               by the presentation attributes) is different.  This attribute must be
|               set for objects created via 
|		.symbol index kpds_create_object 
|		or output objects else get/put data calls will fail.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_SIZE			"size"

/*------------------------------------------------------------------------
| Attribute:	KDMS_DIMENSION
| Type:		int dim
| Default:      
| Category:     segment
| Legal Values: 
| Description:	This attribute is used to get or set the dimensionality
|		of a data segment.  For example, a signal is a 1-D data
|		set, so a special segment to store a single signal could
|		have a dimensionality of 1.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_DIMENSION			"dimension"

/*------------------------------------------------------------------------
| Attribute:	KDMS_TRANSFERABLE
| Type:		int dim
| Default:      TRUE
| Category:     segment
| Legal Values: TRUE
|		FALSE
| Description:	This attribute is used to determine if a segment is 
|		copied to a destination via
|		.symbol index kdms_copy_object() .
|		If set to 
|      		.symbol noindex TRUE , 
|		then
|		.symbol index kdms_copy_object()
|		will copy the segment to the destination object.  If it is set to
|		.symbol noindex FALSE ,
|		then it will not be copied with the other segments in the
|		data set.  This capability is used to some applications
|		to store information which will be invalid if other data segments
|		are operated on, such as statistical information.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_TRANSFERABLE		"transferable"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PHYSICAL_DATA_TYPE
| Type:		int dim
| Default:      
| Category:     segment
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Description:	This attribute is used to get the data type, or 
|		numerical representation of the data at the physical level.  
|		Ordinarily, attribute setting and getting retrieve the 
|		presentation value of an attribute.  However, there are
|		some rare instances where direct access to the physical
|		representation of the data is necessary, but it is desirable
|		to maintain the existing presentation attributes.  Otherwise,
|		this attribute is identical to 
|		.symbol index KDMS_DATA_TYPE .  
|		It is the difference between
|		the value of this attribute and the value of the 
|		.symbol index KDMS_DATA_TYPE
|		attribute that will cause a cast operation to occur
|		during calls to 
|		.symbol index kpds_get_data()
|		and
|		.symbol index kpds_put_data() .
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_PHYSICAL_DATA_TYPE		"physical_data_type"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PHYSICAL_INDEX_ORDER
| Type:		int *order
| Default:      
| Category:     segment
| Legal Values: 
| Description:	This attribute is used to get the index order of the data 
|		at the physical level.  Ordinarily, attribute setting and 
|		getting retrieve the presentation value of an attribute.  
|		However, there are
|		some rare instances where direct access to the physical
|		representation of the data is necessary, but it is desirable
|		to maintain the existing presentation attributes.  Otherwise,
|		this attribute is identical to 
|		.symbol index KDMS_INDEX_ORDER .  
|		It is the difference between
|		the value of this attribute and the value of the 
|		.symbol index KDMS_INDEX_ORDER
|		attribute that can cause a re-ordering of the data, similar
|		to a matrix transposition
|		during calls to 
|		.symbol index kpds_get_data()
|		and
|		.symbol index kpds_put_data() .
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_PHYSICAL_INDEX_ORDER	"physical_index_order"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PHYSICAL_SIZE
| Type:		int *size
| Default:      
| Category:     segment
| Legal Values: 
| Description:	This attribute is used to get the size of the data 
|		at the physical level.  Ordinarily, attribute setting and 
|		getting retrieve the presentation value of an attribute.  
|		However, there are
|		some rare instances where direct access to the physical
|		representation of the data is necessary, but it is desirable
|		to maintain the existing presentation attributes.  Otherwise,
|		this attribute is identical to 
|		.symbol index KDMS_SIZE .  
|		It is the difference between
|		the value of this attribute and the value of the 
|		.symbol index KDMS_SIZE
|		attribute that can cause an interpolation or padding to occur
|		during calls to 
|		.symbol index kpds_get_data()
|		and
|		.symbol index kpds_put_data()
|		based on the value of the 
|		.symbol index KDMS_INTERPOLATE
|		attribute.
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_PHYSICAL_SIZE		"physical_size"

/*------------------------------------------------------------------------
| Attribute:	KDMS_PHYSICAL_DIMENSION
| Type:		int dim
| Default:      
| Category:     segment
| Legal Values: > 0
| Description:	This attribute is used to get the dimensionality of the data 
|		at the physical level.  Ordinarily, attribute setting and 
|		getting retrieve the presentation value of an attribute.  
|		However, there are
|		some rare instances where direct access to the physical
|		representation of the data is necessary, but it is desirable
|		to maintain the existing presentation attributes.  Otherwise,
|		this attribute is identical to 
|		.symbol index KDMS_DIMENSION .
|		Currently, there should be no difference between this
|		value and the value of 
|		.symbol index KDMS_DIMENSION .
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KDMS_PHYSICAL_DIMENSION		"physical_dimension"

/*------------------------------------------------------------------------
| Attribute:	KDMS_OFFSET
| Type:		int *offset
| Default:      0, 0, 0, 0, 0
| Category:     segment
| Legal Values: 
| Description:	This attribute specifies a relative offset from zero of the
|		origin of the data set.  This value will be added to the
|		begin and end corner markers on all get and put data 
|		operations.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KDMS_OFFSET			"dmsOffset"


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 * this stuff is for the callbacks.
 */

typedef struct _kposition
{
  int w, h, d, t, e;
} kposition;

typedef struct _dacallback
{
   kobject object;    /* object that was "put" on */
   char *segment;     /* the segment that it was put on */
   char *type;
   kposition begin;
   kposition end;
} kdms_callback;

   
        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

extern int
   KDMS_EINTERNAL,
   KDMS_ELIMITATION,
   KDMS_ENULLOP,
   KDMS_EWRACCESS,
   KDMS_EREADWRITE_LIMITATION,
   KDMS_EOBJ_INVALID,
   KDMS_EOBJ_SUPPORT,
   KDMS_ESEG_EXISTS,
   KDMS_ESEG_NONEXIST,
   KDMS_ESEG_VALID,
   KDMS_ESEG_LOCKED,
   KDMS_ESEG_READFAIL,
   KDMS_EFMT_FAILURE,
   KDMS_EFMT_READFAIL,
   KDMS_EFMT_WRITEFAIL,
   KDMS_EFMT_OPENFAIL,
   KDMS_EFMT_INIT,
   KDMS_EATTR_SIZEDIM,
   KDMS_EATTR_ORDERDIM,
   KDMS_EATTR_NULLARGS,
   KDMS_EATTR_NODEF,
   KDMS_EATTR_INVALID,
   KDMS_EATTR_ILLEGAL_ASSOC,
   KDMS_EATTR_UNSET,
   KDMS_EATTR_NOT_FOUND,
   KDMS_EATTR_ALREADY_EXISTS,
   KDMS_EATTR_DEF_EXISTS,
   KDMS_EATTR_SET_FAILED,
   KDMS_EATTR_GET_FAILED,
   KDMS_EATTR_COPY_FAILED,
   KDMS_ECOMP_ALLOC_FAIL,
   KDMS_ECOMP_POS_INVALID,
   KDMS_EDIM_INVALID,
   KDMS_EDIM_NO_MATCH,
   KDMS_EINDX_INVALID,
   KDMS_ESYNC_NOT,
   KDMS_ESYNC_INVALID,
   KDMS_ECB_NONEXIST;

	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/************************************************************
*
*  Routine Name: kdms_input - open an input object for 
*		 reading
*
*       Purpose: This function is a simplified
*                interface to the kdms_open function.  It
*                differs in that it assumes that the object
*                is read-only and its transport has permenance.
*                If a permanent file is not desired (i.e.
*                the object is going to be used as temporary
*                storage, and will not be used by any other
*                process) then the kdms_create function
*                call should be used instead.
*
*		 The argument to this function is
*		 the transport or file name.  This argument
*		 indicates the name of the transport that
*		 is associated with the object.  The transport
*		 name can be any legal khoros transport
*		 description.  While this will usually be a
*		 regular UNIX file name, it is also possible
*		 to specify such things as shared memory pointers,
*		 memory map pointers, sockets, streams, and
*		 even transports on other machines.  For more
*		 information on the syntax of a Khoros transport
*		 name, refer to the online man page for the
*		 Khoros function kopen.  For more information,
*		 about opening an object, see kdms_open.
*
*		 This function is equivalent to:
*
*	!	kdms_open(name, KOBJ_READ)
*
*	  Input: name - a string that contains the path name
*			of a file or transport that will be 
*			associated with the object.
*
*        Output: none
*
*       Returns: a kobject on success, KOBJECT_INVALID on failure.
*
*  Restrictions:
*
*    Written By: Jeremy Worley
*          Date: Feb 16, 1993 08:57
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: kobject kdms_input(
*		!   char *name)
*
*************************************************************/

#define kdms_input(name)  kdms_open(name, KOBJ_READ)

/************************************************************
*
*  Routine Name: kdms_output - open an input object for 
*		 writing
*
*       Purpose: This function is a simplified
*                interface to the kdms_open function.  It
*                differs in that it assumes that the object
*                is write-only and its transport has permenance.
*                If a permanent file is not desired (i.e. the
*                object is going to be used as temporary storage,
*                and will not be used by any other process)
*                then the kdms_create function call
*                should be used instead.
*
*		 The argument to this function is
*		 the transport or file name.  This argument
*		 indicates the name of the transport that
*		 is associated with the object.  The transport
*		 name can be any legal khoros transport
*		 description.  While this will usually be a
*		 regular UNIX file name, it is also possible
*		 to specify such things as shared memory pointers,
*		 memory map pointers, sockets, streams, and
*		 even transports on other machines.  For more
*		 information on the syntax of a Khoros transport
*		 name, refer to the online man page for the
*		 Khoros function kopen.
*		 For more information, see kdms_open.
*
*		 This function is equivalent to:
*
*	!	kdms_open(name, KOBJ_WRITE)
*
*	  Input: name - a string that contains the path name
*			of a file or transport that will be 
*			associated with the object.
*
*        Output: none
*
*       Returns: a kobject on success, KOBJECT_INVALID on failure.
*
*  Restrictions:
*
*    Written By: Jeremy Worley
*          Date: Feb 16, 1993 08:57
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: kobject kdms_output(
*		!   char *name)
*
*************************************************************/

#define kdms_output(name) kdms_open(name, KOBJ_WRITE)

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* kdataserv.c */

/*
 * Information
 */
char **kdms_support PROTO((int *));

/*
 *  Declaration for public general object manipulation routines.
 */
kobject kdms_create            PROTO((void));
kobject kdms_open              PROTO((char *, int));
kobject kdms_reopen            PROTO((kobject, char *, int));
int     kdms_close             PROTO((kobject));
int	kdms_lock	       PROTO((kobject));
int	kdms_sync	       PROTO((kobject, char *, int));
kobject kdms_reference         PROTO((kobject));
int	kdms_error	       PROTO((char *, char *, char *, kvalist));

int     kdms_copy_segment_data PROTO((kobject, char *, kobject, char *));
int     kdms_copy_object       PROTO((kobject, kobject, int, int));
int     kdms_copy_remaining_data PROTO((kobject, kobject));

int     kdms_update_references PROTO((kobject, char *));
klist  *kdms_reference_list    PROTO((kobject));
klist *kdms_get_segment_list   PROTO((kobject));
char **kdms_get_segment_names  PROTO((kobject,int *));
int    kdms_rename_segment     PROTO((kobject, char *, char *));

/*
 *  Declaration for public get and set data manipulation routines
 */
kaddr   Xkdms_get_data         PROTO((kobject, char *, char *, kaddr));
int     Xkdms_put_data         PROTO((kobject, char *, char *, kaddr));
kaddr   kdms_get_data          PROTO((kobject, char *, int *, int *, kaddr));
int     kdms_put_data          PROTO((kobject, char *, int *, int *, kaddr));

/*
 *  Declaration for public attribute manipulation routines.
 */

int kdms_define_quasi_attribute PROTO((char *, char *, kaddr, 
	    int (*) PROTO ((kobject ,int ,int ,kaddr ,kva_list *)), 
	    int (*) PROTO ((kobject ,int ,int ,kaddr ,kva_list *)), 
	    int (*) PROTO ((kobject ,kobject ,int ,int ,kaddr ,kaddr )), 
	    int (*) PROTO ((kobject ,kobject ,int ,int ,kaddr ,kaddr )), 
	    int (*) PROTO ((kobject ,int ,int,kaddr,int *,int *,int *,int *)),
	    int (*) PROTO ((kobject ,int ,int ,kaddr ,kfile *)) ));
int kdms_define_attribute   PROTO((char *, char *, int, int, int, int, int,
				   kvalist ));
int kdms_undefine_attribute PROTO((char *, char *));
int kdms_query_attribute_definition PROTO((char *, char *));

int kdms_create_attribute  PROTO((kobject, char *, char *, 
				  int, int, int, int, int));
int kdms_destroy_attribute PROTO((kobject, char *, char *));
int kdms_set_attribute     PROTO((kobject, char *, char *, kvalist ));
int kdms_set_attributes    PROTO((kobject, char *, kvalist ));
int kdms_get_attribute     PROTO((kobject, char *, char *, kvalist ));
int kdms_get_attributes    PROTO((kobject, char *, kvalist ));
int kdms_match_attribute   PROTO((kobject, kobject, char *, char *));
int kdms_match_attributes  PROTO((kobject, kobject, char *, kvalist ));
int kdms_copy_attribute    PROTO((kobject, kobject, char *, char *));
int kdms_copy_attributes   PROTO((kobject, kobject, char *, kvalist ));
int kdms_query_attribute   PROTO((kobject, char *, char *, int *, int *, 
  				  int *, int *));
int kdms_print_attribute   PROTO((kobject, char *, char *, kfile *));

/* variable argument variants of the attribute routines. */
int kdms_vset_attribute    PROTO((kobject, char *, char *, kva_list *));
int kdms_vset_attributes   PROTO((kobject, char *, kva_list *));
int kdms_vget_attribute    PROTO((kobject, char *, char *, kva_list *));
int kdms_vget_attributes   PROTO((kobject, char *, kva_list *));
int kdms_vmatch_attributes PROTO((kobject, kobject, char *, kva_list *));
int kdms_vcopy_attributes  PROTO((kobject, kobject, char *, kva_list *));

/* 
 * this thing is private, but necessary for kprdata...it will be rolled
 * into a public function with more general capabilities in the future.
 */
char ** kdms_get_stored_attribute_names PROTO((kobject, char *, int *));

/* basic attribute list utilities */
char **kdms_get_attribute_names PROTO((kobject,char *,char *,int,int *));

int kdms_copy_segment_attributes PROTO((kobject, char *, kobject, char *));

/* callbacks */
int kdms_add_callback	      PROTO((kobject,char *,char *,kfunc_void,kaddr));
int kdms_remove_callback      PROTO((kobject,char *,char *,kfunc_void,kaddr));

/* segment stuff */
int kdms_create_segment	      PROTO((kobject, char *));
int kdms_destroy_segment	      PROTO((kobject, char *));
int kdms_query_segment	      PROTO((kobject, char *));

int kdms_define_segment PROTO((char *,
   int 	 (*) PROTO((kobject, char *)),
   int 	 (*) PROTO((kobject, char *)),
   int 	 (*) PROTO((kobject, char *)),
   kaddr (*) PROTO((kobject, char *, int *, int *, kaddr)),
   int   (*) PROTO((kobject, char *, int *, int *, kaddr)),
   int   (*) PROTO((kobject, char *, char *, kva_list *)),
   int   (*) PROTO((kobject, char *, char *, kva_list *)),
   int   (*) PROTO((kobject, kobject, char *, char *)),
   int   (*) PROTO((kobject, kobject, char *, char *)),
   int   (*) PROTO((kobject, char *, char *,int *,int *,int *,int *)),
   int   (*) PROTO((kobject, char *, char *, kfile *)) ));

int kdms_undefine_segment         PROTO((char *));
int kdms_query_segment_definition PROTO((char *));

/* private */
kobject kdms_locate	      PROTO((char *));

/*
 * Candy
 */
int _kdms_get_order PROTO((int, int *, int *, int, int));
int _kdms_set_order PROTO((int, int *, int *, int, int));
kfunc_int kdms_close_hook PROTO((kobject, kfunc_int));

#endif /* _kdataman_kdataman_h_ */
/* Don't add after this point */
