 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Color Service Routines
   >>>>
   >>>>    Written By: Mark Young and Steve Kubica
   >>>>
   >>>>          Date: Jul 08, 1993 12:38
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kappserv_kcolor_h_
#define _kappserv_kcolor_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  predefined colormaps for images
 */
#define   KORIGINAL       0
#define   KMAP332	  1
#define   KCIE_DIAGRAM    2
#define   KEQUALIZE       3
#define   KSTRETCH        4
#define   KDENSITY_SLICE  5
#define   KDISJOINT	  6
#define   KGREYCODE	  7
#define   KGREYSCALE      8
#define   KHLS_RINGS      9
#define   KHLS_SPIRAL     10
#define   KHSV_RINGS      11
#define   KRGB_CUBE       12
#define   KRGB_DISTANCE   13
#define   KRGB_SPIRAL     14
#define   KRGB_TRIANGLE   15
#define   KRAINBOW        16
#define   KRANDOM         17
#define   KSA_PSEUDO      18
#define   KSTDDEV         19

/*
 *  predefined colormap operations for images
 */

#define   KBLUE_FILTER    100
#define   KCHAIN_ROTLEFT  101
#define   KCHAIN_ROTRIGHT 102
#define   KGREEN_FILTER   103
#define   KINVERT_ORIG    104
#define   KINVERT         105
#define   KRED_FILTER     106
#define   KREVERSE        107
#define   KBLUE_ROTLEFT   108
#define   KBLUE_ROTRIGHT  109
#define   KCOL_ROTLEFT    110
#define   KCOL_ROTRIGHT   111
#define   KGREEN_ROTLEFT  112
#define   KGREEN_ROTRIGHT 113
#define   KRED_ROTLEFT    114
#define   KRED_ROTRIGHT   115
#define   KROW_ROTLEFT    116
#define   KROW_ROTRIGHT   117
#define   KSWAP_GREENBLUE 118
#define   KSWAP_REDBLUE   119
#define   KSWAP_REDGREEN  120


/*
 *  defines for colorspaces
 */
#define KGREY            1
#define KRGB             2
#define KCMY             3
#define KYIQ             4
#define KHSV             5
#define KHLS             6
#define KIHS             7
#define KXYZ             8
#define KUVW             9
#define KUCSUVW         10
#define KUCSSOW         12
#define KUCSLab         13
#define KUCSLuv         14
#define KUSERDEFINED    15


/* ################################################################## */

	/*
	 *   Attribute Definitions
	 */

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_MAP_AUTOCOLOR
| Type:         int autocolor
| Category:     object
| Default:      KORIGINAL
| Legal Values: KORIGINAL       
|               KRGB_CUBE       
|		KRGB_TRIANGLE   
|               KRGB_SPIRAL     
|		KHLS_SPIRAL     
|		KHSV_RINGS      
|		KHLS_RINGS      
|		KRGB_DISTANCE   
|		KCIE_DIAGRAM    
|		KDENSITY_SLICE  
|		KGREYSCALE      
|		KEQUALIZE       
|		KSTRETCH        
|               KSTDDEV         
|               KSA_PSEUDO      
|               KRAINBOW        
|               KDISJOINT       
|               KGREYCODE       
|               KMAP332 
|               KRANDOM 
|
| Description:  This attribute, when called, will create a colormap
|		on an object using the specified autocoloring procedure.
|		There are two types of autocolor mapping schemes available.
|		The first is \fIpositional mapping\fP, in which the map 
|		values at any position are generated only as a function 
|		of that position.  The second is \fIdata dependent\fP 
|		mapping, in which the map values at any position are
|		generated as a function of the value data.  The 
|		specifics of each autocoloring procedure were explained
|		in earlier sections.
|
|		The original colormap, if a colormap was present, is saved
|		and can be restored by setting this attribute to 
|		\f(CWKORIGINAL\fP.  Note that the original colormap will not
|		be carried along with the data object once it is closed.
| Access:
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_MAP_AUTOCOLOR		"colorAutocolor"

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_MAP_AUTOCOLOR_LIST
| Type:         char **ac_list
|		int    num
| Category:     object
| Default:      
| Legal Values: 
|               
| Description:  This attribute returns a list of strings indicating
|		which map autocoloring procedures are available.
|		A number argument indicates how many autocoloring
|		procedures are included in the list.	     
|	
| Access:       read only
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_MAP_AUTOCOLOR_LIST	"colorAutocolorList"

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_MAP_OPERATION
| Type:         int operation
| Category:     object
| Default:      KNONE
| Legal Values: KINVERT         
|               KINVERT_ORIG    
|		KREVERSE        
|               KROW_ROTLEFT    
|		KROW_ROTRIGHT   
|		KCOL_ROTLEFT    
|		KCOL_ROTRIGHT   
|		KSWAP_REDGREEN  
|		KSWAP_REDBLUE   
|		KSWAP_GREENBLUE 
|		KRED_FILTER     
|		KGREEN_FILTER   
|		KBLUE_FILTER    
|               KCHAIN_ROTLEFT  
|               KCHAIN_ROTRIGHT 
|               KRED_ROTLEFT    
|               KRED_ROTRIGHT   
|               KGREEN_ROTLEFT  
|               KGREEN_ROTRIGHT 
|               KBLUE_ROTLEFT   
|		KBLUE_ROTRIGHT  
|
| Description:  This attribute, when called, will operate on the existing
|		colormap within a data object using the specified colormap
|		operation.  A colormap operation will generate a new 
|		colormap based on the values in the existing colormap.
|		If an object has no colormap, then setting this attribute
|		will have no effect.
|		
|		The original colormap will be saved before it is altered
|		by any colormap operations and can be restored by setting
|		the attribute \f(CWKCOLORMAP_OPERATIONS\fP to 
|		\f(CWKORIGINAL\fP.  Note that the original colormap will not 
|		be carried along with the data object once it is closed.  
| Access:
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_MAP_OPERATION		"colorAutocolorOperation"

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_MAP_OPERATION_LIST
| Type:         char **op_list
|		int    num
| Category:     object
| Default:      
| Legal Values: 
|               
| Description:  This attribute returns a list of strings indicating
|		which map operations are available. A number argument
|		indicates how many autocoloring procedures are included 
|		in the list.	     
|	
| Access:       read only
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_MAP_OPERATION_LIST	"colorOperationList"

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_COLORSPACE
| Type:         int colorspace
| Category:     object
| Default:      KNONE
| Legal Values: KNONE
|               KGREY           
|		KRGB            
|               KCMY            
|		KYIQ            
|		KHSV            
|		KHLS            
|		KIHS            
|		KXYZ            
|		KUVW            
|		KUCSUVW         
|		KUCSSOW         
|		KUCSLab         
|               KUCSLuv         
|               KUSERDEFINED    
|               
| Description:  This attribute indicates the colorspace in which the
|		data in the element vectors of the value segment, or
|		map segment if it is present, are stored.
|	
| Access:
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_COLORSPACE		"colorColorspace"

/*------------------------------------------------------------------------
| Attribute:    KCOLOR_HAS_ALPHA
| Type:         int has_alpha
| Category:     object
| Default:      FALSE
| Legal Values: 
|               
| Description:  This attribute indicates whether or not an alpha value
|		is contained in the element vectors of the value
|		segment, or map segment if it is present.
|	
| Access:
| Persistence:  permanent
------------------------------------------------------------------------*/
#define	  KCOLOR_HAS_ALPHA 		"hasAlpha"

#define   KCOLOR_ALPHA_MIN		"alphaMin"
#define   KCOLOR_ALPHA_MAX		"alphaMax"


	/*
	 *   Attribute Defaults
	 */

#define   KCOLOR_MAP_AUTOCOLOR_DEFAULT		KORIGINAL
#define   KCOLOR_MAP_OPERATION_DEFAULT		KNONE
#define   KCOLOR_COLORSPACE_DEFAULT		KNONE
#define   KCOLOR_HAS_ALPHA_DEFAULT		FALSE

	/*
	 * Initialization Function for Color Services 
	 */

void	kcolor_init			PROTO((void));
#define KCOLOR_INIT			kcolor_init()


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* color.c */
int kcolor_get_attribute    PROTO((kobject, char *, kvalist ));
int kcolor_get_attributes   PROTO((kobject, kvalist ));
int kcolor_set_attribute    PROTO((kobject, char *, kvalist ));
int kcolor_set_attributes   PROTO((kobject, kvalist ));
int kcolor_match_attribute  PROTO((kobject, kobject, char *));
int kcolor_match_attributes PROTO((kobject, kobject, kvalist ));
int kcolor_copy_attribute   PROTO((kobject, kobject, char *));
int kcolor_copy_attributes  PROTO((kobject, kobject, kvalist ));
int kcolor_query_attribute  PROTO((kobject, char *,int *,int *,int *,int *));
int kcolor_print_attribute  PROTO((kobject, char *, kfile *));

int kcolor_gamut_object     PROTO((kobject, int, int, float, kobject));

#endif /* _kappserv_kcolor_h_ */
/* Don't add after this point */
