#! /bin/sh

echo "running test.sh for ksegcmp ... process ($$)"

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

tbpath=`kecho -tb SAMPLEDATA -echo path`

# ------------------------------------------------------------------------
# Test  1:  comparing identical images
# ------------------------------------------------------------------------
test_num=1
descr="comparing ball.xv with itself"
ksegcmp -i1 image:ball -i2 image:ball > out
if cmp -s out test.results/test1 
then 
   echo "Passed:  Test  $test_num --> "$descr""
else
   echo "FAILED:  Test  $test_num --> "$descr""
   status=1
fi 
/bin/rm -f out

# ------------------------------------------------------------------------
# Test  2:  comparing radically different images 
# ------------------------------------------------------------------------
test_num=2
descr="comparing ball.xv with head.xv"
ksegcmp -i1 image:ball -i2 image:head > out
if cmp -s out test.results/test2
then 
   echo "Passed:  Test  $test_num --> "$descr""
else
   echo "FAILED:  Test  $test_num --> "$descr""
   status=1
fi 
/bin/rm -f out

# ------------------------------------------------------------------------
# Test  3:  comparing similar images 
# ------------------------------------------------------------------------
test_num=3
descr="comparing ball.xv with moon.xv"
ksegcmp -i1 image:ball -i2 image:moon -tol 220 -pos -i1val -i2val > out
if cmp -s out test.results/test3
then 
   echo "Passed:  Test  $test_num --> "$descr""
else
   echo "FAILED:  Test  $test_num --> "$descr""
   status=1
fi 
/bin/rm -f out

exit $status
