#! /bin/sh 

echo "running test1.sh for kpad ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

# ---------- Test 1a --> pad 4x4 to 8x6, real = 100, offset (2,1) valid 1, int

test_num=1a
descr="pad 4x4 to 8x6, real = 100, offset (2,1) valid 1, int"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
-2 -1 -3 7
7 58 59 13
36 3 38 1
1 -2 -3 -4
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type Integer -wsize 4 -hsize 4
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 6 -real 100 -woff 2 -hoff 1

cat <<EOF > $tmpdir/ascii2.$$
100 100 100 100 100 100 100 100 
100 100 -2  -1  -3  7   100 100
100 100 7   58  59  13  100 100
100 100 36   3  38  1   100 100
100 100 1   -2  -3  -4  100 100
100 100 100 100 100 100 100 100 
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Integer -wsize 8 -hsize 6
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 1b --> pad 4x4 to 8x6, real = 100, offset (2,1) valid 0, int

test_num=1b
descr="pad 4x4 to 8x6, real = 100, offset (2,1) valid 0, int"
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 6 -real 100 -woff 2 -hoff 1 -valid 0

# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii2.$$
0 0 0 0 0 0 0 0 
0 0 1 1 1 1 0 0
0 0 1 1 1 1 0 0
0 0 1 1 1 1 0 0
0 0 1 1 1 1 0 0
0 0 0 0 0 0 0 0 
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 6
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2a --> pad 4x4 to 8x6, pad value = 100, offset (-1,2)

test_num=2a
descr="pad 4x4 to 8x6, pad value = 100, offset (-1,2)"
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -real 100 -woff -1 -hoff 2

cat <<EOF > $tmpdir/ascii2.$$
100 100 100 100 100 100 100 100 
100 100 100 100 100 100 100 100 
-1  -3  7   100 100 100 100 100
58  59  13  100 100 100 100 100
 3  38  1   100 100 100 100 100
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Integer -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"


# ---------- Test 2b --> pad 4x4 to 8x6, pad value = 100, offset (-1,2) valid 0

test_num=2b
descr="pad 4x4 to 8x6, pad value = 100, offset (-1,2) valid 0"

kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -real 100 -woff -1 -hoff 2 -valid 0

# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii2.$$
0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
1 1 1 0 0 0 0 0 
1 1 1 0 0 0 0 0 
1 1 1 0 0 0 0 0 
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2c --> pad mask, val 4x4 to 8x6, real=100, off=(-1,2) valid 0

test_num=2c
descr="pad mask, val 4x4 to 8x6, real=100, off=(-1,2) valid 0"

cat <<EOF > $tmpdir/ascii.$$
1 0 1 0
0 1 0 1
1 0 1 0
0 1 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/vdata.$$ -o $tmpdir/vmdata.$$ -type "unsigned byte" -wsize 4 -hsize 4
kpad -i $tmpdir/vmdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -real 100 -woff -1 -hoff 2 -valid 0

# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii2.$$
0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
0 1 0 0 0 0 0 0 
1 0 1 0 0 0 0 0 
0 1 0 0 0 0 0 0 
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2d --> pad mask, val 4x4 to 8x6, real=100, off=(-1,2) valid 1

test_num=2d
descr="pad mask, val 4x4 to 8x6, real=100, off=(-1,2) valid 1"

kpad -i $tmpdir/vmdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -real 100 -woff -1 -hoff 2 -valid 1

# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii2.$$
1 1 1 1 1 1 1 1 
1 1 1 1 1 1 1 1 
0 1 0 1 1 1 1 1 
1 0 1 1 1 1 1 1 
0 1 0 1 1 1 1 1 
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"


# ---------- Test 3a --> pad mask only 4x4 to 8x6, off=(-1,2) valid 1

test_num=3a
descr="pad mask only 4x4 to 8x6, off=(-1,2) valid 1"
kasc2mask -i1 $tmpdir/ascii.$$ -o $tmpdir/mdata.$$ -type "unsigned byte" -wsize 4 -hsize 4
kpad -i $tmpdir/mdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -woff -1 -hoff 2 -valid 1
kasc2mask -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 3b --> pad mask only 4x4 to 8x6, off=(-1,2) valid 0

test_num=3b
descr="pad mask only 4x4 to 8x6, off=(-1,2) valid 0"

kpad -i $tmpdir/mdata.$$ -o $tmpdir/out.$$ -wsize 8 -hsize 5 -woff -1 -hoff 2 -valid 0
# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii2.$$
0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
0 1 0 0 0 0 0 0 
1 0 1 0 0 0 0 0 
0 1 0 0 0 0 0 0 
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 8 -hsize 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4a --> pad 1x4x1x1x1 to 4x5x1x1x1 pad value = -1.234

test_num=4a
descr="pad 1x4x1x1x1 to 4x5x1x1x1 pad value = -1.234"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
-1 -3 7 2.45
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type float -hsize 4
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 5 -real -1.234 

# create result
cat <<EOF > $tmpdir/ascii2.$$
-1 -3 7 2.45
-1.234 -1.234 -1.234 -1.234
-1.234 -1.234 -1.234 -1.234
-1.234 -1.234 -1.234 -1.234
-1.234 -1.234 -1.234 -1.234
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Float -wsize 5 -hsize 4 -hindex 1 -windex 2 -dindex 3 -tindex 4 -eindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4b --> pad 1x1x1x1x4 to 4x1x1x1x5 pad value = -1.234, valid 0

test_num=4b
descr="pad 1x1x1x1x4 to 4x1x1x1x5 pad value = -1.234, valid 0"
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type float -esize 4
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 5 -real -1.234 -valid 0

# create result
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Float -wsize 5 -esize 4 -eindex 1 -windex 2 -dindex 3 -tindex 4 -hindex 5
cat <<EOF > $tmpdir/ascii2.$$
1 1 1 1
0 0 0 0
0 0 0 0
0 0 0 0
0 0 0 0
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 5 -esize 4 -eindex 1 -windex 2 -dindex 3 -tindex 4 -hindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 5a --> complex 1x1x2x1x2 to 1x1x4x1x3 pad val (-1.234,4.321)

test_num=5a
descr="complex 1x1x2x1x2 to 1x1x4x1x3 pad val (-1.234,4.321)"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
(-1, 4.3) (-3.5, 2.1) 
(7, -20) (8, 2.45)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type complex -dsize 2 -esize 2 -eindex 1 -dindex 2 -windex 3 -hindex 4 -tindex 5
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -dsize 4 -esize 3 -real -1.234 -imag 4.321

# create result
cat <<EOF > $tmpdir/ascii2.$$
(-1, 4.3)       (-3.5, 2.1)     (-1.234, 4.321)
(7, -20)        (8, 2.45)       (-1.234, 4.321)
(-1.234, 4.321) (-1.234, 4.321) (-1.234, 4.321)
(-1.234, 4.321) (-1.234, 4.321) (-1.234, 4.321)
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type complex -dsize 4 -esize 3 -eindex 1 -dindex 2 -windex 3 -hindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 6a --> single point to 2x2x2x2x2, real=42, valid=1

test_num=6a
descr="single point to 2x2x2x2x2, real=42, valid=1"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
11
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type "unsigned short" 
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 2 -hsize 2 -dsize 2 -tsize 2 -esize 2 -real 42

# create result
cat <<EOF > $tmpdir/ascii2.$$
11 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
42 42
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "unsigned short" -wsize 2 -hsize 2 -dsize 2 -tsize 2 -esize 2 -eindex 1 -dindex 2 -windex 3 -hindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 6b --> single point to 2x2x2x2x2, real=42, valid=0

test_num=6b
descr="single point to 2x2x2x2x2, real=42, valid=0"
kpad -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -wsize 2 -hsize 2 -dsize 2 -tsize 2 -esize 2 -real 42 -valid 0

# create result mask
cat <<EOF > $tmpdir/ascii2.$$
1 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
0 0
EOF
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 2 -hsize 2 -dsize 2 -tsize 2 -esize 2 -eindex 1 -dindex 2 -windex 3 -hindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 7a --> pad data with value and map

test_num=7a
descr="pad data with value and map"
/bin/rm $tmpdir/vmdata.$$

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
3
2
1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vmdata.$$ -hsize 3 -type "unsigned short" 

# Create map data 
cat <<EOF > $tmpdir/ascii.$$
0 0  0
1 11 21
2 12 22
3 13 23 
4 14 24 
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/vmdata.$$ -o $tmpdir/vmdata.$$ -wsize 3 -hsize 5 -type float
kpad -i $tmpdir/vmdata.$$ -o $tmpdir/out.$$ -hsize 4 

# create result
cat <<EOF > $tmpdir/ascii2.$$
3 
2 
1 
0  
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "unsigned short" -hsize 4 
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -wsize 3 -hsize 5 -type float
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 8a --> object with curvilinear location (fail state)

test_num=8a

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
3
2
1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vldata.$$ -hsize 3 -type "unsigned short" 

# Create location data 
cat <<EOF > $tmpdir/ascii.$$
3 13 23 
2 12 22
1 11 21
EOF
kasc2loc -i1 $tmpdir/ascii.$$ -i2 $tmpdir/vldata.$$ -o $tmpdir/vldata.$$ -hsize 3 -type float
kpad -i $tmpdir/vldata.$$ -o $tmpdir/out.$$ -hsize 4 > $tmpdir/err.$$ 2>&1

if [ $? = 0 ]
then
   echo "FAILED:  Test  8a --> object with curvilinear location (fail state)"
   status=1
else
   echo "Passed:  Test  8a --> object with curvilinear location (fail state)"
fi

# ---------- Test 8b --> object with uniform location data
test_num=8b
descr="object with uniform location data"

/bin/rm $tmpdir/vldata.$$
# Create value data 
cat <<EOF > $tmpdir/ascii.$$
3
2
1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vldata.$$ -hsize 3 -type "unsigned short" 

ksetdattr -i $tmpdir/vldata.$$ -o $tmpdir/vldata.$$ -wbegin 27 -wend 300 -hbegin 0 -hend 1 -dbegin 0 -dend 1 
kpad -i $tmpdir/vldata.$$ -o $tmpdir/out.$$ -hsize 4 

# create result
cat <<EOF > $tmpdir/ascii2.$$
3 
2 
1 
0  
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "unsigned short" -hsize 4 
ksetdattr -i $tmpdir/answer.$$ -o $tmpdir/answer.$$ -wbegin 27 -wend 300 -hbegin 0 -hend 1 -dbegin 0 -dend 1 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"


# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------

/bin/rm $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$ $tmpdir/answer.$$ 
/bin/rm $tmpdir/vdata.$$ $tmpdir/vmdata.$$ $tmpdir/mdata.$$ $tmpdir/vldata.$$
/bin/rm $tmpdir/err.$$
exit $status

