#! /bin/sh 

echo "running test1.sh for korient ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data and for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"

# ---------- Test 1 --> w6h5d4t3e2 -ww -hh -dd -tt -ee

test_num=1
descr="w6h5d4t3e2 -ww -hh -dd -tt -ee"

korient -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out.$$ -ww -hh -dd -tt -ee 
report $test_num "$tmpdir/out.$$" "$dpath/w6h5d4t3e2.val.float.viff" "$descr"

# ---------- Test 2 --> data set of one point
 
test_num=2
descr="data set of one point"
 
korient -i $dpath/1pt.float.xv -o $tmpdir/out.$$ -wd -he -dd -te -ee
report $test_num "$tmpdir/out.$$" "$dpath/1pt.float.xv" "$descr"

# ---------- Test 3 --> w6h5d4t3e2 -wh -hd -dw -tt -ee

test_num=3
descr="w6h5d4t3e2 -wh -hd -dw -tt -ee"

korient -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out.$$ -wh -hd -dw -tt -ee
kaxis -i $dpath/w6h5d4t3e2.val.float.viff -o $tmpdir/out2.$$ -wh -hd -dw
report $test_num "$tmpdir/out.$$" "$tmpdir/out2.$$" "$descr"

# ---------- Test 4a --> 3x2x2x1x1 -ww -hh -de -tt -ee

test_num=4a
descr="3x2x2x1x1 -ww -hh -de -tt -ee"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 11 12
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -dsize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -ww -hh -de -tt -ee
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -wsize 3 -hsize 2 -esize 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# Create mask data
cat <<EOF > $tmpdir/ascii2.$$
1 0 0
0 1 1
0 1 0
0 1 1
EOF
# ---------- Test 4b --> 3x2x2x1x1 -ww -hh -de -tt -ee, with mask

test_num=4b
descr="3x2x2x1x1 -ww -hh -de -tt -ee, with mask"

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -dsize 2
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type "unsigned byte" -wsize 3 -hsize 2 -dsize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -ww -hh -de -tt -ee
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -wsize 3 -hsize 2 -esize 2
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 3 -hsize 2 -esize 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/answer.$$

# ---------- Test 5a --> 3x2x1x1x2 -wh -hw -dd -tt -ed

test_num=5a
descr="3x2x1x1x2 -wh -hw -dd -tt -ed"

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wh -hw -dd -tt -ed
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -wsize 2 -hsize 3 -dsize 2 -hindex 1 -windex 2 -dindex 3 -tindex 4 -eindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 5b --> 3x2x1x1x2 -wh -hw -dd -tt -ed, with mask

test_num=5b
descr="3x2x1x1x2 -wh -hw -dd -tt -ed, with mask"

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type "unsigned byte" -wsize 3 -hsize 2 -esize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wh -hw -dd -tt -ed
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -wsize 2 -hsize 3 -dsize 2 -hindex 1 -windex 2 -dindex 3 -tindex 4 -eindex 5
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -wsize 2 -hsize 3 -dsize 2 -hindex 1 -windex 2 -dindex 3 -tindex 4 -eindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 6a --> 3x2x1x1x2 -we -he -de -te -ee

test_num=6a
descr="3x2x1x1x2 -we -he -de -te -ee"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 11 12
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -we -he -de -te -ee
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -esize 12
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 6b --> 3x2x1x1x2 -we -he -de -te -ee

test_num=6b
descr="3x2x1x1x2 -we -he -de -te -ee with mask"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 11 12
EOF
# Create mask data
cat <<EOF > $tmpdir/ascii2.$$
1 0 0
0 1 1
0 1 0
0 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type "unsigned byte" -wsize 3 -hsize 2 -esize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -we -he -de -te -ee
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -esize 12
kasc2mask -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "unsigned byte" -esize 12
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 7a --> 3x2x1x1x2 -wd -he -dt -te -et, with map

test_num=7a
descr="3x2x1x1x2 -wd -he -dt -te -et, with map"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 11 12
EOF
# Create map data
cat <<EOF > $tmpdir/ascii2.$$
1.23 2.23 3.23
4.23 4.23 6.23
7.23 8.23 9.23
10.23 11.23 12.23
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
kasc2map -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type float -wsize 3 -hsize 4 
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wd -he -dt -te -et
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -tsize 2 -esize 2 -dsize 3 -hindex 4  -windex 5 -dindex 1 -tindex 3  -eindex 2
kasc2map -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type float -wsize 3 -hsize 4 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 7b --> 3x2x1x1x2 -wd -he -dt -te -et, map (md != 1)
 
test_num=7b
descr="3x2x1x1x2 -wd -he -dt -te -et, map, md != 1, fail state"
 
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -esize 2
kasc2map -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type float -wsize 3 -hsize 2 -dsize 2

korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wd -he -dt -te -et > $tmpdir/err.$$ 2>&1
if [ $? = 0 ]
then
   echo "FAILED:  Test  $test_num --> $descr"
   status=1
else
   echo "Passed:  Test  $test_num --> $descr"
fi

/bin/rm -f  $tmpdir/data.$$

# ---------- Test 8a --> 3x2x1x1x2 -wd -he -dt -te -et, curvilinear loc 

test_num=8a
descr="3x2x1x1x2 -wd -he -dt -te -et, curvilinear loc, fail state"

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -dsize 2
kasc2loc -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/data.$$ -o $tmpdir/data.$$ -type float -wsize 3 -hsize 2 -dsize 2

korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wd -he -dt -te -et > $tmpdir/err.$$ 2>&1
if [ $? = 0 ]
then
   echo "FAILED:  Test  $test_num --> $descr"
   status=1
else
   echo "Passed:  Test  $test_num --> $descr"
fi

# ---------- Test 8b --> 3x2x1x1x2 -wd -he -dt -te -et, uniform loc

test_num=8b
descr="3x2x1x1x2 -wd -he -dt -te -et, no uniform loc"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 11 12
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 2 -dsize 2
# ksetdattr -i $tmpdir/data.$$ -o $tmpdir/data.$$ -wbegin 27 -wend 300 -hbegin 0 -hend 1 -dbegin 0 -dend 1 -tbegin 0 -tend 1 -ebegin 0 -eend 1
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -wd -he -dt -te -et
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -tsize 2 -esize 2 -dsize 3 -hindex 4  -windex 5 -dindex 1 -tindex 3  -eindex 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 9 --> 3x2x1x1x2 -ww -hh -dd -tt -ew

test_num=9
descr="3x2x1x1x2 -ww -hh -dd -tt -ew"

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
1 2 3
4 5 6
7 8 9
10 20 30
40 50 60
70 80 90
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type short -wsize 3 -hsize 3 -esize 2
korient -i $tmpdir/data.$$ -o $tmpdir/out.$$ -ww -hh -dd -tt -ew
cat <<EOF > $tmpdir/ascii.$$
1 2 3 10 20 30
4 5 6 40 50 60
7 8 9 70 80 90
EOF
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/answer.$$ -type short -wsize 6 -hsize 3
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm $tmpdir/ascii.$$ $tmpdir/data.$$ $tmpdir/out.$$ $tmpdir/answer.$$

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------

/bin/rm -f $tmpdir/out.$$ $tmpdir/out2.$$ $tmpdir/data.$$ $tmpdir/answer.$$
/bin/rm -f $tmpdir/err.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$
exit $status

