#! /bin/sh 

echo "running test4.sh for knormal ... process ($$)"

echo "         Test  4 Normalize value (0-255), combination of dimensions"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  4:  normalize value (0-255), combination of dimensions
# ------------------------------------------------------------------------

# create and import data
cat <<EOF > $tmpdir/ascii.$$
-1 -2 -3
57 58 59
36 37 38
-2 -3 -4
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type Integer -wsize 3 -hsize 4

# ---------- Test 4a --> along width    (-w)

test_num=4a
descr="along width    (-w)"
knormal -i $tmpdir/data.$$ -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float -w
# create results file for comparison
cat <<EOF > $tmpdir/ascii2.$$
255	127.5	0
0	127.5	255
0	127.5	255
255	127.5	0
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Float -wsize 3 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4b --> along height   (-h)

test_num=4b
descr="along height   (-h)"
knormal -i $tmpdir/data.$$ -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float -h
# create results file for comparison
cat <<EOF > $tmpdir/ascii2.$$
4.322033898	4.180327869	4.047619048
255		255		255
164.2372881	167.2131148	170
0		0		0
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Float -wsize 3 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4c --> along depth    (-d)

test_num=4c
descr="along depth    (-d)"
kasc2val -i1 $tmpdir/ascii.$$ -dsize 4 -wsize 3 -type Integer -o $tmpdir/data.$$ -windex 1 -dindex 2 -hindex 3 -tindex 4 -eindex 5
knormal -i $tmpdir/data.$$ -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float -d
# use same answer as height, but read in differently
kasc2val -i1 $tmpdir/ascii2.$$ -dsize 4 -wsize 3 -type Float -o $tmpdir/answer.$$ -windex 1 -dindex 2 -hindex 3 -tindex 4 -eindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4d --> along time     (-t)

test_num=4d
descr="along time     (-t)"
kasc2val -i1 $tmpdir/ascii.$$ -tsize 4 -wsize 3 -type Integer -o $tmpdir/data.$$ -windex 1 -tindex 2 -hindex 3 -dindex 4 -eindex 5
knormal -i $tmpdir/data.$$ -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float -t
# use same answer as height, but read differently
kasc2val -i1 $tmpdir/ascii2.$$ -tsize 4 -wsize 3 -type Float -o $tmpdir/answer.$$ -windex 1 -tindex 2 -hindex 3 -dindex 4 -eindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4e --> along elements (-e)

test_num=4e
descr="along elements (-e)"
kasc2val -i1 $tmpdir/ascii.$$ -hsize 4 -esize 3 -type Integer -o $tmpdir/data.$$ -eindex 1 -hindex 2 -windex 3 -dindex 4 -tindex 5
knormal -i $tmpdir/data.$$ -e -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float
# create results file for comparison
cat <<EOF > $tmpdir/ascii2.$$
255	127.5	0
0	127.5	255
0	127.5	255
255	127.5	0
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -esize 3 -type Float -o $tmpdir/answer.$$ -eindex 1 -hindex 2 -windex 3 -dindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4f --> width-height planes (-w -h)

test_num=4f
descr="width-height planes (-w -h)"
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -dsize 2 -type Integer -o $tmpdir/data.$$
knormal -i $tmpdir/data.$$ -w -h -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float
cat <<EOF > $tmpdir/ascii2.$$
8.225806236	4.112903118	0
246.7742004	250.8871002	255
242.8571472	248.9285736	255
12.14285755	6.071428776	0
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -wsize 3 -hsize 2 -dsize 2 -type Float -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4g --> whole thing (-whole)

test_num=4g
descr="whole thing (-whole)"
kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/data.$$ -type Integer -wsize 3 -hsize 4
knormal -i $tmpdir/data.$$ -whole -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float
cat <<EOF > $tmpdir/ascii2.$$
12.14285755	8.095237732	4.047618866
246.9047546	250.9523773	255
161.9047546	165.9523773	170
8.095237732	4.047618866	0
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Float -wsize 3 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4h --> whole thing (-w -h -d -t -e)

test_num=4h
descr="whole thing (-w -h -d -t -e)"
knormal -i $tmpdir/data.$$ -w -h -d -t -e -uval 255 -lval 0 -o $tmpdir/out.$$ -type Float
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 4i --> volume (-w -h -d)

test_num=4i
descr="volume (-w -h -d)"

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------
/bin/rm $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$ 
/bin/rm $tmpdir/data.$$ $tmpdir/answer.$$

exit $status

