#! /bin/sh

echo "running test2.sh for klogexp ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}


kconvert -i image:head -o $tmpdir/ref.$$ -type Double -val
# ------------------------------------------------------------------------
# Test  1:  exp of ln(image:head)
# ------------------------------------------------------------------------
test_num=1
descr="exp of ln(image:head)"
klogexp -i image:head -o $tmpdir/jnk1.$$ -be  
klogexp -i $tmpdir/jnk1.$$ -o $tmpdir/jnk2.$$ -be -inv
report $test_num "$tmpdir/ref.$$" "$tmpdir/jnk2.$$" "$descr"
/bin/rm -f $tmpdir/jnk*.$$ 

# ------------------------------------------------------------------------
# Test  2:  inverse log10 of log10(image:head)
# ------------------------------------------------------------------------
test_num=2
descr="inverse log10 of log10(image:head)"
klogexp -i image:head -o $tmpdir/jnk1.$$ -b10
klogexp -i $tmpdir/jnk1.$$ -o $tmpdir/jnk2.$$ -b10 -inv
report $test_num "$tmpdir/ref.$$" "$tmpdir/jnk2.$$" "$descr"
/bin/rm -f $tmpdir/ref.$$ $tmpdir/jnk*.$$ 

exit $status
