#! /bin/sh

echo "running test1.sh for klogexp ... process ($$)" 

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  log - float input, log10 no offset
# ------------------------------------------------------------------------
test_num=1
descr="log - float input, log10 no offset"
klogexp -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -b10 -offset 0
report $test_num "$tmpdir/out.$$" "test1.results/3x4f_log10_0off" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  log - float input, log10 no offset
# ------------------------------------------------------------------------
test_num=2
descr="log - float input, log10 no offset"
klogexp -i $dpath/4x2.float.xv -o $tmpdir/out.$$ -b10 -offset 0
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_log10_0off" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  log - float input, ln 1 offset
# ------------------------------------------------------------------------
test_num=3
descr="log - float input, ln 1 offset"
klogexp -i $dpath/4x2.float.xv -o $tmpdir/out.$$ -be -offset 1
report $test_num "$tmpdir/out.$$" "test1.results/4x2f_ln_1off" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  log - float input, ln 1 offset
# ------------------------------------------------------------------------
test_num=4
descr="log - float input, ln 1 offset"
klogexp -i $dpath/3x4.float.viff -be -offset 1 -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test1.results/3x4f_ln_1off" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  5:  exp - float input, natural base, 1 offset
# ------------------------------------------------------------------------
test_num=5
descr="exp - float input, natural base, 1 offset"
klogexp -i test1.results/3x4f_ln_1off -inv -be -offset 1 -o $tmpdir/out.$$
kconvert -i $dpath/3x4.float.viff -o $tmpdir/ref.$$ -type Double -val
report $test_num "$tmpdir/out.$$" "$tmpdir/ref.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ref.$$

exit $status
