#! /bin/sh 

echo "testing kimportraw  ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  4x2 big endian IEEE float into value segment
# ------------------------------------------------------------------------
test_num=1
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -o $tmpdir/raw.$$ -wsize 4 -hsize 2 -type float -arch 3 -segment 1
descr="Big Endian IEEE:  4x2 float data set into value segment"
report $test_num "$tmpdir/raw.$$" "test1.results/4x2.float.value" "$descr"
/bin/rm -f $tmpdir/raw.$$

# ------------------------------------------------------------------------
# Test  2:  4x2 big endian IEEE float into mask segment
# ------------------------------------------------------------------------
test_num=2
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -o $tmpdir/raw.$$ -wsize 4 -hsize 2 -type float -arch 3 -segment 2
descr="Big Endian IEEE:  4x2 float data set into mask segment"
report $test_num "$tmpdir/raw.$$" "test1.results/4x2.float.mask" "$descr"
/bin/rm -f $tmpdir/raw.$$

# ------------------------------------------------------------------------
# Test  3:  4x2 big endian IEEE float into map segment
# ------------------------------------------------------------------------
test_num=3
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -o $tmpdir/raw.$$ -wsize 4 -hsize 2 -type float -arch 3 -segment 3
descr="Big Endian IEEE:  4x2 float data set into map segment"
report $test_num "$tmpdir/raw.$$" "test1.results/4x2.float.map" "$descr"
/bin/rm -f $tmpdir/raw.$$

# ------------------------------------------------------------------------
# Test  4:  4x2 big endian IEEE float into location segment
# ------------------------------------------------------------------------
test_num=4
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -o $tmpdir/raw.$$ -wsize 4 -hsize 2 -type float -arch 3 -segment 4
descr="Big Endian IEEE:  4x2 float data set into location segment"
report $test_num "$tmpdir/raw.$$" "test1.results/4x2.float.location" "$descr"
/bin/rm -f $tmpdir/raw.$$

# ------------------------------------------------------------------------
# Test  5:  8 big endian IEEE floats into time segment
# ------------------------------------------------------------------------
test_num=5
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -o $tmpdir/raw.$$ -tsize 8 -type float -arch 3 -segment 5
descr="Big Endian IEEE:  8 floats into time segment"
report $test_num "$tmpdir/raw.$$" "test1.results/8.float.time" "$descr"
/bin/rm -f $tmpdir/raw.$$

# ------------------------------------------------------------------------
# Test  6:  4x2 big endian IEEE floats mask segment of another data set
# ------------------------------------------------------------------------
test_num=6
kimportraw -i1 $datapath/4x2.ieeebe.float.raw -i2 $datapath/4x2.float.xv -o $tmpdir/raw.$$ -wsize 4 -hsize 2 -type float -arch 3 -segment 2
descr="Big Endian IEEE:  4x2 floats into mask of existing data set"
report $test_num "$tmpdir/raw.$$" "test1.results/4x2.float.insert" "$descr"
/bin/rm -f $tmpdir/raw.$$

exit $status
