#! /bin/sh

echo "running test2.sh for kgate ... process ($$)"

# 8-29-94 - changed tolerance on test 1, part 2, part 3, result 1, result 2 
# from 1e-5 to 1e-4.  See discussion in header of karith2/test2.sh. - dk

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# Recommended tolerance value 1e-5.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for image data, and temporary directories
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
bpath=`kecho -tb DATAMANIP -echo path`/bin
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  head and ball, gated by moon thresholded at 128, (logic 1)
# ------------------------------------------------------------------------
test_num=1

# Create a gating input (and it's inverse for stats testing)
descr="Part 1: moon thresholded at 128 (0,255) - kcompare, karith2, kstats"
kcompare -i1 $dpath/moon.xv -real 128 -ge -tval 255 -fval 0 -o $tmpdir/gate.$$
kcompare -i1 $dpath/moon.xv -real 128 -lt -tval 255 -fval 0 -o $tmpdir/invgate.$$
# Make sure gates are really compliments of each other
karith2 -i1 $tmpdir/invgate.$$ -i2 $tmpdir/gate.$$ -add -o $tmpdir/out.$$
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/t1p1.stats" "$descr" "1e-5"

# Normalize the head data so that it looks pretty with the ball data
knormal -w -h -i $dpath/head.xv -o $tmpdir/head_255.$$ -uval 255 -lval 0 

# Calculate statistics of gated head and gated ball for later comparison
descr="Part 2: gated stats on normalized head - knormal, kstats"
kstats -i $tmpdir/head_255.$$ -igate $tmpdir/gate.$$ -o $tmpdir/stats.$$ \
	-whole -mean -var -sd -minval -maxval -pts
report $test_num "$tmpdir/stats.$$" "test2.results/t1_ghead.stats" "$descr" "1e-4"

descr="Part 3: gated statistics on ball"
kstats -i $dpath/ball.xv -igate $tmpdir/invgate.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test2.results/t1_gball.stats" "$descr" "1e-4"

# Run kgate
descr="Result 1: head, ball, gated by moon (gval = 255, logic = 0)"
$bpath/kgate -i1 $tmpdir/head_255.$$ -i2 $dpath/ball.xv -igate $tmpdir/gate.$$ \
      -o $tmpdir/out.$$ -gval 255 -logic 0
kstats -i $tmpdir/out.$$ -igate $tmpdir/invgate.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/t1_gball.stats" "$descr" "1e-4"

descr="Result 2: head, ball, gated by moon (gval = 0, logic = 1)"
$bpath/kgate -i1 $tmpdir/head_255.$$ -i2 $dpath/ball.xv -igate $tmpdir/gate.$$ \
      -o $tmpdir/out.$$ -gval 0 -logic 1
kstats -i $tmpdir/out.$$ -igate $tmpdir/invgate.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/t1_gball.stats" "$descr" "1e-4"

/bin/rm -f $tmpdir/out.$$ $tmpdir/gate.$$ $tmpdir/stats.$$ \
	   $tmpdir/head_255.$$ $tmpdir/invgate.$$

exit $status
