#! /bin/sh

echo "running test3.sh for kextract ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  2x3ival_6x3fmap_2x3bmask (no parameters specified)
# ------------------------------------------------------------------------
test_num=1
descr="2x3ival_6x3fmap_2x3bmask (no parameters specified)"
kextract -i $dpath/2x3ival_6x3fmap_2x3bmask.viff -o $tmpdir/out.$$ -subpos FALSE
report $test_num "$tmpdir/out.$$" "$dpath/2x3ival_6x3fmap_2x3bmask.viff" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kextract -i ~mirage/datamanip/data/testdata/2x3ival_6x3fmap_2x3bmask.viff -o junk -subpos FALSE
# ksegcmp -i1 junk -i2 ~mirage/datamanip/data/testdata/2x3ival_6x3fmap_2x3bmask.viff

# ------------------------------------------------------------------------
# Test  2:  2x3ival_6x3fmap_2x3bmask -woff 1 -hoff 1 -wsize 2 -hsize 2
# ------------------------------------------------------------------------
test_num=2
descr="2x3ival_6x3fmap_2x3bmask -woff 1 -hoff 1 -wsize 2 -hsize 2"
kextract -i $dpath/2x3ival_6x3fmap_2x3bmask.viff -o $tmpdir/out.$$ -woff 1 -hoff 1 -wsize 2 -hsize 2 -subpos FALSE
report $test_num "$tmpdir/out.$$" "test3.results/vmm_wo1ho1ws2hs2" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kextract -i ~mirage/datamanip/data/testdata/2x3ival_6x3fmap_2x3bmask.viff -o junk -woff 1 -hoff 1 -wsize 2 -hsize 2 -subpos FALSE

# ------------------------------------------------------------------------
# Test  3:  w6h5d4t3e2.fval.floc woff 1 hoff 1 eoff 1 wsize 1 hsize 2 dsize 3
# ------------------------------------------------------------------------
test_num=3
descr="w6h5d4t3e2.fval.floc.viff woff 1 hoff 1 eoff 1 wsize 1 hsize 2 dsize 3"
kextract -i $dpath/w6h5d4t3e2.fval.floc.viff -o $tmpdir/out.$$ -woff 1 -hoff 1 -eoff -1 -wsize 1 -hsize 2 -dsize 3 -subpos FALSE
report $test_num "$tmpdir/out.$$" "test3.results/vl_wo1ho1eo-1ws1hs2ds3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kextract -i ~mirage/datamanip/data/testdata/w6h5d4t3e2.fval.floc.viff -o junk -woff 1 -hoff 1 -eoff -1 -wsize 1 -hsize 2 -dsize 3 -subpos FALSE

exit $status
