#! /bin/sh

echo "running test1.sh for kcompare ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}


# ------------------------------------------------------------------------
# Test  1:  IF image:head < 1000.0, THEN out = 255, ELSE out = 0
# ------------------------------------------------------------------------
test_num=1
descr="IF image:head < 1000.0, THEN out = 255, ELSE out = 0"
kcompare -i1 image:head -o $tmpdir/junk1.$$ -real 1000.0 -tval 255.0 -fval 0.0 -lt   
kstats -i $tmpdir/junk1.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test1.results/head_lt1000.255.0.stats" "$descr" "1e-4"

# ------------------------------------------------------------------------
# Test  2:  IF image:moon >= 160.0, THEN out = 255, ELSE out = 0
# ------------------------------------------------------------------------
test_num=2
descr="IF image:moon >= 160.0, THEN out = 255, ELSE out = 0"
kcompare -i1 image:moon -o $tmpdir/junk1.$$ -real 160.0 -tval 255.0 -fval 0.0 -ge   
kstats -i $tmpdir/junk1.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test1.results/moon_ge160.255.0.stats" "$descr" "1e-5"

# ------------------------------------------------------------------------
# Test  3:  IF image:moon < 160.0, THEN out = 1, ELSE out = 0
# ------------------------------------------------------------------------
test_num=3
descr="IF image:moon < 160.0, THEN out = 1, ELSE out = 0"
kcompare -i1 image:moon -o $tmpdir/junk1.$$ -real 160.0 -tval 1.0 -fval 0.0 -lt
kstats -i $tmpdir/junk1.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test1.results/moon_lt160.1.0.stats" "$descr" "1e-5"

# ------------------------------------------------------------------------
# Test  4:  IF image:moon > 1000.0, THEN out = -2550, ELSE out = 99
# ------------------------------------------------------------------------
test_num=4
descr="IF image:moon > 1000.0, THEN out = -2550, ELSE out = 99"
kcompare -i1 image:moon -o $tmpdir/junk1.$$ -real 1000.0 -tval -2550.0 -fval 99.0 -gt   
kstats -i $tmpdir/junk1.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test1.results/moon_gt160.1.0.stats" "$descr" "1e-5"

# ------------------------------------------------------------------------
# Test  5:  IF image:head = image:head, THEN out = -1, ELSE out = 99
# ------------------------------------------------------------------------
test_num=5
descr="IF image:head = image:head, THEN out = -1, ELSE out = 99"
kcompare -i1 image:head -i2 image:head -o $tmpdir/junk1.$$ -tval -1.0 -fval 99.0 -eq   
kstats -i $tmpdir/junk1.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test1.results/head_eq_head.-1.99.stats" "$descr" "1e-5"

rm -rf  $tmpdir/junk1.$$ $tmpdir/stats.$$

exit $status
