#! /bin/sh

echo "running test2.sh for karith2 ... process ($$)"

# 8-29-94 - changed tolerances on test 3 and 5 from 1e-4 to 1e-3.  
# The ksegcmp tolerance for tests 3 and 5 were changed from 1e-4 to 
# 1e-3 because these tests were failing on the ibmrs6000.  I verified that 
# the actual data generated by the tests were the same for different systems.
# The tests were failing because the variance and values derived from variance 
# returned by kstats were not within the 1e-4 tolerance.  The data that
# is failing is head x 4.  The average value of head is 1066, so kstats
# is choking on computing the variance of (1066x4x256x228).  It is in
# the plans to rework kstats to be able to accurately compute statistics
# on large values/large data sets. - dk

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# recommended tolerance is 1e-4.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
bpath=`kecho -tb DATAMANIP -echo path`/bin
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  add -  image:ball + 34
# ------------------------------------------------------------------------
test_num=1
descr="add -  image:ball + 34"
$bpath/karith2 -i1 image:ball -o $tmpdir/jnk.$$ -add -real 34  
kstats -i $tmpdir/jnk.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/ball_add34.stats" "$descr" "1e-4"
/bin/rm -f $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  2:  sub -  (image:ball + 34) -34
# ------------------------------------------------------------------------
test_num=2
descr="sub -  (image:ball + 34) -34"
$bpath/karith2 -i1 $tmpdir/jnk.$$ -o $tmpdir/jnk2.$$ -sub -real 34
kstats -i $tmpdir/jnk2.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/ball_add34sub34.stats" "$descr" "1e-4"
/bin/rm -f $tmpdir/jnk.$$ $tmpdir/jnk2.$$ $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  3:  mul -  image:head x 4.0
# ------------------------------------------------------------------------
test_num=3
descr="mul -  image:head x 4.0"
$bpath/karith2 -i1 image:head -o $tmpdir/jnk3.$$ -real 4.0 -mul
kstats -i $tmpdir/jnk3.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/head_mul4.stats" "$descr" "1e-3"
/bin/rm -f $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  4:  div -  (image:head x 4.0)/4.0
# ------------------------------------------------------------------------
test_num=4
descr="div -  (image:head x 4.0)/4.0"
$bpath/karith2 -i1 $tmpdir/jnk3.$$ -o $tmpdir/jnk4.$$ -real 4.0 -div
kstats -i $tmpdir/jnk4.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/head_mul4div4.stats" "$descr" "1e-4"
/bin/rm -f $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  5:  absdiff -  |(image:head x 4.0) - (image:head x 4.0)/4.0|
# ------------------------------------------------------------------------
test_num=5
descr="absdiff -  |(image:head x 4.0) - (image:head x 4.0)/4.0|"
$bpath/karith2 -i1 $tmpdir/jnk3.$$ -i2 $tmpdir/jnk4.$$ -o $tmpdir/jnk5.$$ -absdiff
kstats -i $tmpdir/jnk5.$$ -o $tmpdir/stats.$$ -all
report $test_num "$tmpdir/stats.$$" "test2.results/head_mul4_absdiff_head_mul4div4.stats" "$descr" "1e-3"
/bin/rm -f $tmpdir/jnk*.$$ $tmpdir/stats.$$

exit $status
