#! /bin/sh

echo "running test2.sh for karith1 ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object 
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

report_loose()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1.5e-4 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  atan of 3x4masked.double.viff
# ------------------------------------------------------------------------
test_num=1
descr="atan of 3x4masked.double.viff"
karith1 -i $dpath/3x4masked.double.viff -o $tmpdir/jnk.$$ -atan
report $test_num "$tmpdir/jnk.$$" "test2.results/3x4md_atan" "$descr"
/bin/rm -f $tmpdir/jnk.$$

# ------------------------------------------------------------------------
# Test  2:  tan of atan(3x4masked.double.viff)
# ------------------------------------------------------------------------
test_num=2
descr="tan of atan(3x4masked.double.viff)"
karith1 -i test2.results/3x4md_atan -o $tmpdir/jnk.$$ -tan
report $test_num "$tmpdir/jnk.$$" "$dpath/3x4masked.double.viff" "$descr"
/bin/rm -f $tmpdir/jnk.$$ 

# ------------------------------------------------------------------------
# Test  3:  sqrt of image:head
# ------------------------------------------------------------------------
test_num=3
descr="sqrt of image:head"
karith1 -i image:head -o $tmpdir/jnk1.$$ -sqrt
kstats -i $tmpdir/jnk1.$$ -o $tmpdir/stats.$$ -mean -var -minval -maxval\
	 -sd -pts 
report $test_num "$tmpdir/stats.$$" "test2.results/sqrt_head.stats" "$descr"
/bin/rm -f $tmpdir/stats.$$

# ------------------------------------------------------------------------
# Test  4:  square of sqrt(image:head)
# ------------------------------------------------------------------------
test_num=4
descr="testing karith1 and karith2 - square of sqrt(image:head)"
karith2 -i1 $tmpdir/jnk1.$$ -i2 $tmpdir/jnk1.$$ -o $tmpdir/jnk2.$$ -mul
karith2 -i1 image:head -i2 $tmpdir/jnk2.$$ -o $tmpdir/jnk2.$$ -sub
karith1 -i $tmpdir/jnk2.$$ -o $tmpdir/jnk2.$$ -abs
kstats -i $tmpdir/jnk2.$$ -o $tmpdir/stats.$$ -maxval
kgconst -o $tmpdir/res.$$ -wsize 1 -hsize 1 -dsize 1 -real 0 -type 11
report_loose $test_num "$tmpdir/stats.$$" "$tmpdir/res.$$" "$descr"
/bin/rm -f $tmpdir/jnk1.$$ $tmpdir/jnk2.$$ $tmpdir/stats.$$ $tmpdir/res.$$

exit $status
