 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kconvert
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkconvert
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkconvert - convert, offset, and/or scale data in specified segment
* 
*       Purpose: This routine will convert, offset and/or scale
*		 the segment specified by segment_name of the
*		 input object source_object and create a new
*		 object destination_object containing the modified
*		 segment and all the other segments which will be
*		 unmodified.  The data type to convert to will be
*		 passed in data_type_string and should be one of
*		 these values:
*
*                .TS H
*                center tab(:) ;
*                lfB  lfB  lfB
*                l    l    lf(CW) .
*                Data Type:Abbreviation:Data Type
*                =
*                .TH
*                bit              :bi     : KBIT
*                byte             :by     : KBYTE
*                unsigned byte    :un by  : KUBYTE
*                ubyte            :uby    : KUBYTE
*                short            :sh     : KSHORT
*                unsigned short   :un sh  : KUSHORT
*                ushort           :ush    : KUSHORT
*                integer          :in     : KINT
*                unsigned integer :un in  : KUINT
*                uint             :ui     : KUINT
*                long             :lon    : KLONG
*                unsigned long    :un lon : KULONG
*                ulong            :ul     : KULONG
*                float            :fl     : KFLOAT
*                double           :do     : KDOUBLE
*                complex          :co     : KCOMPLEX
*                double complex   :do co  : KDCOMPLEX
*                dcomplex         :dc     : KDCOMPLEX
*                .T&
*                l s s.
*                Propagate Input Type - will not change the data type
*                .TE
*
*		 The scale value is specified by scale and the
*		 offset value by real_offset & imaginary_offset.
*
*         Input: source_object    - the object to get the segment from
*                segment_name     - the segment to convert
*		 data_type_string - data type to convert to
*		 scale            - value to scale the data by
*		 real_offset      - real value to offset data by
*		 imaginary_offset - imaginary value to offset data by
*
*        Output: destination_object - the resulting object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: John M. Salas & Donna Koechner
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkconvert(
   kobject source_object,
   char    *segment_name,
   char    *data_type_string,
   double  scale,
   double  real_offset,
   double  imaginary_offset,
   kobject destination_object)
/* -library_def_end */

/* -library_code */
{
   int data_type = 0;
   int dim;
   int i;
   int dt;
   int *begin;
   int *end;
   int *size;
   kaddr data = NULL;
   kobject reference_object;

   /*
    * Check parameters passed in.
    */
   if (kstrcmp(data_type_string, "Propagate Input Type") &&
       (data_type = kdatatype_to_define(data_type_string)) == 0)
   {
      kerror("ksegops", "lkconvert", "Not a proper data type '%s'.",
	     data_type_string);
      return (FALSE);
   }

   if (!kdms_query_segment(source_object, segment_name))
   {
      kerror("ksegops", "lkconvert", "Segment does not exist '%s'.",
	     segment_name);
      return (FALSE);
   }

   /*
    * Copy all the segment from the source object to the destination
    * object unmodified.
    */
   if (!kdms_copy_object(source_object, destination_object, TRUE, TRUE))
   {
      kerror("ksegops", "lkconvert", "Failed to duplicate \
source object to destination object.");
      return (FALSE);
   }

   /*
    * If no scaling is specified and no data type change is desired
    * the routine is finished.
    */
   if (scale == 1.0 && real_offset == 0.0 && imaginary_offset == 0.0 &&
       data_type == 0)
   {
      return (TRUE);
   }

   /*
    * Set attributes to do offset, scaling and data type.
    */
   kdms_get_attributes(source_object, segment_name,
		       KDMS_SIZE, &size,
		       KDMS_DIMENSION, &dim,
		       KDMS_DATA_TYPE, &dt,
		       NULL);

   if (data_type == 0)
      data_type = dt;

   if (!kdms_set_attribute(destination_object, segment_name,
			   KDMS_DATA_TYPE, data_type))
   {
      kerror("ksegops", "lkconvert", "Failed to set data type on \
segment '%s'.", segment_name);
      return (FALSE);
   }

   /*
    * Reference the destination_object and set the data type on
    * reference_object to be the same as the source_object so that
    * when you get the data from the source_object and put it into
    * the reference_object it will be of the same type.  Data Services
    * will convert the data type since the destination_object's
    * data type is the one the user specified.
    */
   reference_object = kdms_reference(destination_object);

   if (data_type != dt)
   {
      kdms_set_attribute(reference_object, segment_name, KDMS_DATA_TYPE, dt);
   }

   /*
    * Set scaling mode on the destination reference if scale and offset
    * specified.
    */
   if (scale != 1.0 || real_offset != 0.0 || imaginary_offset != 0.0)
   {
      if (!kdms_set_attribute(reference_object, segment_name,
			      KDMS_SCALING, KSCALE))
      {
	 kerror("ksegops", "lkconvert", "Could not set scaling on.");
	 return (FALSE);
      }
   }

   kdms_set_attributes(reference_object, segment_name,
		       KDMS_SCALE_FACTOR, scale,
		       KDMS_SCALE_OFFSET, real_offset, imaginary_offset,
		       NULL);

   /*
    * Get the data and put it into the reference_object so that the
    * data type conversion and scaling is done.
    */
   begin = (int *)kmalloc(kmax(5, dim) * sizeof(int *));
   end = (int *)kmalloc(kmax(5, dim) * sizeof(int *));

   if (!begin || !end)
   {
      kerror("ksegops", "lkconvert", "Could not allocate memory \
for temporary variable.");
      return (FALSE);
   }

   for (i = 0; i < kmax(5, dim); i++)
   {
      if (i >= dim)
      {
	 begin[i] = 0;
	 end[i] = 1;
      }
      else
      {
	 begin[i] = 0;
	 end[i] = size[i] - 1;
      }
   }

   data = kdms_get_data(source_object, segment_name, begin, end, NULL);
   kdms_put_data(reference_object, segment_name, begin, end, data);

   kfree(begin);
   kfree(end);
   kdms_close(reference_object);
   return (TRUE);

}
/* -library_code_end */
