 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kprdata
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkprdata
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkprdata - print object data in ASCII format to file
* 
*       Purpose: Library Routine for kprdata.  Prints attributes
*		 and data and indices associated with each data 
*                segment in formatted ASCII to the print device.  
*                The flags passed in define what will be printed.
*
*         Input: in_obj - Input data object.
*                print_attributes - Flag, if set, print object attributes.
*                print_index - Flag, if set, print indices associated
*                      with value, mask, location and time segments.
*                print_location - Flag, if set, print location data.
*                print_time - Flag, if set, print time data.
*                print_value - Flag, if set, print value data.
*                print_mask - Flag, if set, print mask data.
*                print_map_index - Flag, if set, print indices 
*                      associated with map segment.
*                print_map - Flag, if set, print map data.
*                map_value_data - Flag, if set, map value data through
*                      map before printing, and print the mapped values.
*                replace_flag - Flag, if set, substitute replace_string
*                      for masked values.
*                replace_string - String to substitute for masked values.
*        Output: ascii_out - Output file for printing ASCII data.
*
*       Returns: TRUE (1) on success, FALSE (0) on failure
*  Restrictions: 
*    Written By: Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lkprdata(
   kobject in_obj,
   kfile   *ascii_out,
   int     print_attributes,
   int     print_index,
   int     print_location,
   int     print_time,
   int     print_value,
   int     print_mask,
   int     print_map_index,
   int     print_map,
   int     map_value_data,
   int     replace_flag,
   char    *replace_string)
/* -library_def_end */

/* -library_code */
{
   int            loc_av, loc_type, loc_w, loc_h, loc_d, loc_n;
   int            map_av, map_type, map_w, map_h, map_e, map_d, map_t;
   int            mask_av, mask_type, mask_w, mask_h, mask_d, mask_t, mask_e;
   int	          time_av, time_type, t_t;
   int            val_av, val_type, val_w, val_h, val_d, val_t, val_e;
   int            loc_ptype, time_ptype, val_ptype, map_ptype, mask_ptype;
   int            width, height, depth, tim, w, h, d, t, i, s, e;
   int		  print_types;
   int            grid = KNONE;
   int		  tmp_arch, maskvalpres;
   char	          *tmp_str = NULL;
   long		  *imap_data  = NULL, *iloc_data  = NULL, 
		  *itime_data = NULL, *ival_data  = NULL;
   unsigned long  *uimap_data = NULL, *uival_data = NULL, 
		  *uiloc_data = NULL, *uitime_data = NULL;
   double	  *fmap_data  = NULL, *floc_data = NULL, 
		  *ftime_data = NULL, *fval_data = NULL;
   kdcomplex      *cmap_data  = NULL, *cloc_data = NULL, 
		  *ctime_data = NULL, *cval_data = NULL;
   unsigned char  *bmask_data = NULL;
   char		  *obj_format = NULL;
   char		  *prog="lkprdata";
   char		  *lib="kdatamanip";
   char           **attrs;
   int            num;
   
   loc_w = loc_h = loc_d = loc_n = 1;
   map_w = map_h = map_e = map_d = map_t = 1;
   mask_w = mask_h = mask_d = mask_t = mask_e = 1;
   t_t = 1;

   val_w = val_h = val_d = val_t = val_e = 1;
   width = height = depth = tim = 1;
   loc_av = map_av = mask_av = time_av = val_av = FALSE;

   /* Initialize the processing types to KUBYTE to keep the compiler happy */
   loc_ptype = time_ptype = val_ptype = map_ptype = mask_ptype = KUBYTE;

   /* Reference the input object */
   if ( (in_obj = kpds_reference_object(in_obj)) == KOBJECT_INVALID ) 
   {
      kerror(lib, prog, "kpds_reference_object cannot duplicate input object.");
      return(FALSE);
   }


   /* Determine which data segments are available.  If they have been 
      selected for printing, but do not exist, warn user that they will 
      not be included in output.  If they do exist, get the sizes. */


   /* --- LOCATION SEGMENT --- */
   if (((loc_av=kpds_query_location(in_obj)) == FALSE) && print_location ) 
   {
      kfprintf(ascii_out, 
	"\n#Printing of Location data was requested, but none exists.");
      print_location = FALSE;
   }
   else if (loc_av) 
   {
      if (!kpds_get_attributes(in_obj,
			KPDS_LOCATION_DATA_TYPE, &loc_type,
			KPDS_LOCATION_GRID,      &grid,
			KPDS_LOCATION_SIZE, &loc_w, &loc_h, &loc_d, &loc_n, 
			NULL) ) 
      {
         kerror(lib, prog, "Cannot Determine Size or Data Type of Location.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
      loc_ptype = loc_type;
      width  = loc_w;
      height = loc_h;
      depth  = loc_d;
   }

   
   /* --- MAP SEGMENT --- */
   if (((map_av = kpds_query_map(in_obj)) == FALSE) && print_map) 
   {
      kfprintf(ascii_out, 
	"\n#Printing of Map data was requested, but none exists.");
      print_map = FALSE;
   }
   else if (map_av) 
   {
      if (!kpds_get_attributes(in_obj, 
			KPDS_MAP_DATA_TYPE, &map_type,
			KPDS_MAP_SIZE, &map_w, &map_h, &map_d, &map_t, &map_e, 
			NULL) ) 
      {
         kerror(lib, prog, "Cannot determine size or data type of Map.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
   }

   if (map_value_data)
   { 
      if (map_av && ((val_av = kpds_query_value(in_obj))==TRUE))
      {
         if (!kpds_set_attribute(in_obj, KPDS_MAPPING_MODE, KMAPPED))
         {
            kerror(lib, prog, 
                   "Setting Attribute to map Value data through map failed.");
	    (void) kpds_close_object(in_obj);
            return(FALSE);
         }
         map_av = FALSE;
         print_value = TRUE;
      }
   }

   /* --- MASK SEGMENT --- */
   if (((mask_av = kpds_query_mask(in_obj))==FALSE) && print_mask) 
   {
      kfprintf(ascii_out, 
	"\n#Printing of Mask data was requested, but none exists.");
      print_mask = FALSE;
   }
   else if (mask_av) 
   {
      if (!kpds_get_attributes(in_obj, 
		KPDS_MASK_DATA_TYPE, &mask_type,
	  	KPDS_MASK_SIZE, &mask_w, &mask_h, &mask_d, &mask_t, &mask_e, 
		NULL)) 
      {
         kerror(lib, prog, "Cannot Determine Size or Data Type of Mask.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
      mask_ptype = KBYTE;
      width = mask_w;
      height = mask_h;
      depth = mask_d;
      tim = mask_t;
      if (!kpds_set_attributes(in_obj,
			KPDS_MASK_DATA_TYPE, mask_ptype,
			KPDS_MASK_POSITION, 0, 0, 0, 0, 0,
			NULL))
      {
         kerror(lib, prog, "Cannot Determine Size or Data Type of Mask.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
   }


   /* --- TIME SEGMENT --- */
   if (((time_av = kpds_query_time(in_obj))==FALSE) && print_time) 
   {
      kfprintf(ascii_out, 
	"\n#Printing of Time data was requested, but none exists.");
      print_time = FALSE;
   }
   else if (time_av) 
   {
      if (!kpds_get_attributes(in_obj, 
				KPDS_TIME_DATA_TYPE, &time_type,
				KPDS_TIME_SIZE, &t_t, 
				NULL)) 
      {
         kerror(lib, prog, "Cannot Determine Size or Data Type of Time.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
      time_ptype = time_type;
      tim = t_t;
   }

   
   /* --- VALUE SEGMENT --- */
   if (((val_av = kpds_query_value(in_obj))==FALSE) && print_value) 
   {
      kfprintf(ascii_out, 
	"\n#Printing of Value data was requested, but none exists.");
      print_value = FALSE;
   }
   else if (val_av) 
   {
      if (!kpds_get_attributes(in_obj, 
			KPDS_VALUE_DATA_TYPE, &val_type,
	  		KPDS_VALUE_SIZE, &val_w, &val_h, &val_d, &val_t, &val_e,
			NULL)) 
      {
         kerror(lib, prog, "Cannot Determine Data Type of Value.");
	 (void) kpds_close_object(in_obj);
         return(FALSE);
      }
      val_ptype = val_type;
      width  = val_w;
      height = val_h;
      depth  = val_d;
      tim    = val_t;
   }

   /* -- Print Transport or File name associated with object -- */
   if (kdms_query_attribute(in_obj, NULL, KPDS_NAME, NULL, NULL,
                                 NULL, NULL))
   {
      kpds_get_attribute(in_obj, KPDS_NAME, &tmp_str);
      if (tmp_str != NULL) kfprintf(ascii_out,"\n# Name: %s",tmp_str);
   }

   /* Print all attributes associated with the object if the flag is set */
   if (print_attributes) 
   {
      /* -- Print Comment Field -- */
      if (kdms_query_attribute(in_obj, NULL, KPDS_COMMENT, NULL, NULL,
                                    NULL, NULL))
      {
         kpds_get_attribute(in_obj, KPDS_COMMENT, &tmp_str);
         if (tmp_str != NULL) kfprintf(ascii_out,"\n# Comment:\n%s",tmp_str);
         kfprintf(ascii_out,"# End Comment");
      }

      /* -- Print Machine Architecture Field -- */
      if (kdms_query_attribute(in_obj, NULL, KPDS_ARCHITECTURE, NULL, NULL,
                                    NULL, NULL))
      {
	 tmp_arch = KMACH_UNKNOWN;
         kpds_get_attribute(in_obj, KPDS_ARCHITECTURE, &tmp_arch);
	 tmp_str = kmach_description(tmp_arch);
         if (tmp_str != NULL)
	    kfprintf(ascii_out,"\n# Machine Architecture: %s", tmp_str);
      }

      /* -- Print Date Field -- */
      if (kdms_query_attribute(in_obj, NULL, KPDS_DATE, NULL, NULL,
                                    NULL, NULL))
      {
         kpds_get_attribute(in_obj, KPDS_DATE, &tmp_str);
         if (tmp_str != NULL) 
	    kfprintf(ascii_out,"\n# Date Created: %s",tmp_str);
      }

      /* -- Print Storage Format Field -- */
      if (kdms_query_attribute(in_obj, NULL, KPDS_FORMAT, NULL, NULL,
                                    NULL, NULL))
      {
         kfprintf(ascii_out,"\n# Storage Format: ");
         if (!kpds_get_attribute(in_obj, KPDS_FORMAT, &obj_format))
            kfprintf(ascii_out,"Not Available");
         else {
            kfprintf(ascii_out,"%s",obj_format);
         }
      }

      /* -- Print History Field -- */
      if (kdms_query_attribute(in_obj, NULL, KPDS_HISTORY, NULL, NULL,
                                    NULL, NULL))
      {
         kpds_get_attribute(in_obj,KPDS_HISTORY,&tmp_str);
         if (tmp_str != NULL) 
	    kfprintf(ascii_out,"\n# History: %s",tmp_str);
      }

      /* -- Print Sub-Object Position -- */
      kfprintf(ascii_out,"\n# Sub-Object Position:  ");
      kpds_print_attribute(in_obj, KPDS_SUBOBJECT_POSITION, ascii_out);

      /* -- Print World Coordinate Point Size -- */
      kfprintf(ascii_out,"\n# World Coordinate Point Size:  ");
      kpds_print_attribute(in_obj, KPDS_POINT_SIZE, ascii_out);

      /* -- Print Color Information -- */
      kfprintf(ascii_out,"\n#\n# Color Space Model:  ");
      kcolor_print_attribute(in_obj, KCOLOR_COLORSPACE, ascii_out);
      kfprintf(ascii_out,"\n# Has Alpha Channel:  ");
      kcolor_print_attribute(in_obj, KCOLOR_HAS_ALPHA, ascii_out);

      /* print other attributes in the data object */
      kfprintf(ascii_out,"\n#\n");
      attrs = kdms_get_stored_attribute_names(in_obj, NULL, &num);
      for (i = 0; i < num; i++)
      {
	 if (kstrcmp("colorspace", attrs[i]) != 0 &&
	     kstrcmp("date", attrs[i]) != 0 &&
	     kstrcmp("hasAlpha", attrs[i]) != 0 &&
	     kstrcmp("comment", attrs[i]) != 0 &&
	     kstrcmp("subobject_position", attrs[i]) != 0 &&
	     kstrncmp("location", attrs[i], 8) != 0 &&
	     kstrncmp("internal", attrs[i], 8) != 0 &&
	     kstrcmp("geometryCookie", attrs[i]) != 0 &&
	     kstrcmp("point_size", attrs[i]) != 0)
	 {
	    kfprintf(ascii_out, "# %s: ",attrs[i]);
	    kdms_print_attribute(in_obj, NULL, attrs[i], ascii_out);
	    kfprintf(ascii_out, "\n");
	 }
      }

      if (attrs != NULL)
	 kfree(attrs);

      /* -- Print data type and size of each segment that is available -- */
      kfprintf(ascii_out,"#");

      if (val_av) {
         kfprintf(ascii_out,"\n# -- Value Data --\n# \tData Type: %s (%d)",
         		kdefine_to_datatype(val_type), val_type);
         kfprintf(ascii_out,
            "\n# \tSize: Width = %d, Height = %d, Depth = %d, Time = %d, Elements = %d", 
	    val_w, val_h, val_d, val_t, val_e);
      }

      if (mask_av) {
         kfprintf(ascii_out,"\n# -- Mask Data --\n# \tData Type: %s (%d)",
         		kdefine_to_datatype(mask_type), mask_type);
         kfprintf(ascii_out,
            "\n# \tSize: Width = %d, Height = %d, Depth = %d, Time = %d, Elements = %d", 
	    mask_w, mask_h, mask_d, mask_t, mask_e);
         kfprintf(ascii_out,"\n# Masked Value Presentation:  ");
	 kpds_get_attribute(in_obj,KPDS_MASKED_VALUE_PRESENTATION,&maskvalpres);
	 if (maskvalpres == KUSE_SUBSTITUTE_VALUE)
	 {
            kfprintf(ascii_out,"Use Substite Value");
            kfprintf(ascii_out,"\n#    Substitute Value:  ");
            kpds_print_attribute(in_obj,KPDS_MASK_SUBSTITUTE_VALUE,ascii_out);
	 }
	 else if (maskvalpres == KUSE_ORIGINAL)
            kfprintf(ascii_out,"Use Actual Values");
      }

      if (map_av) {
         kfprintf(ascii_out,"\n# -- Map Data --\n# \tData Type: %s (%d)",
         		kdefine_to_datatype(map_type), map_type);
         kfprintf(ascii_out,
	    "\n# \tSize: Width = %d, Height = %d, Elements = %d,",
	    map_w, map_h, map_e);
         kfprintf(ascii_out,
	    "\n#\t\tDepth Dimension = %d, Time Dimension = %d", map_d, map_t);
      }

      if (loc_av) {
         kfprintf(ascii_out,"\n# -- Location Data --\n# \tData Type: %s (%d)",
         		kdefine_to_datatype(loc_type), loc_type);
         kfprintf(ascii_out,
            "\n# \tSize: Width = %d, Height = %d, Depth = %d, Dimension = %d", 
	    loc_w, loc_h, loc_d, loc_n);
	 kfprintf(ascii_out,
		  "\n# \tGrid Type: %s",
		  (grid == KUNIFORM)     ? "Uniform" : 
		  (grid == KRECTILINEAR) ? "Rectilinear" : 
		  (grid == KCURVILINEAR) ? "Curvilinear" : 
	          (grid == KNONE) ? "None" : "UNKNOWN" );
	if (grid == KUNIFORM)
	{
               /* -- Print Location Begin -- */
	       kfprintf(ascii_out,"\n# \tLocation Begin:  ");
	       kpds_print_attribute(in_obj, KPDS_LOCATION_BEGIN, ascii_out);

	       /* -- Print Location End -- */
	       kfprintf(ascii_out,"\n# \tLocation End:    ");
	       kpds_print_attribute(in_obj, KPDS_LOCATION_END, ascii_out);
	}
      }

      if (time_av) {
         kfprintf(ascii_out,"\n# -- Time Data --\n# \tData Type: %s (%d)",
         		kdefine_to_datatype(time_type), time_type);
         kfprintf(ascii_out,"\n# \tSize: Time Dimension = %d", t_t);
      }
      kfprintf(ascii_out, "\n#\n");

   }

   if (print_location || print_time || print_value || print_mask || 
      print_index) {

      /* Print header describing data output */
      kfprintf(ascii_out,
         "\n# Data Printed in the Following Format\n# ");
      if (map_value_data) 
         kfprintf(ascii_out, "\t(Value Data is Presented after Mapping)\n# ");
      if (print_index) {
         if ( (!print_location) && (!print_value) && (!print_mask))
         {
	    /* If only time is being printed, set the other dimensions
	       to 1 so that they are not printed. */
            width = 1;
            height = 1;
            depth = 1;
         }

         kfprintf(ascii_out,"IMPLICIT INDICES: ");
         if (tim > 1)
            kfprintf(ascii_out,"t ");
         if (depth > 1)
            kfprintf(ascii_out,"d ");
         if (height > 1)
            kfprintf(ascii_out,"h ");
         if (width > 1)
            kfprintf(ascii_out,"w ");
         kfprintf(ascii_out,"  ");
      }
      if (print_location)  
         kfprintf(ascii_out,"LOCATION: %d elements  ",loc_n);
      if (print_time)      
         kfprintf(ascii_out,"TIME: 1 value  ");
      if (print_value)     
         kfprintf(ascii_out,"VALUE: %d elements  ",val_e);
      if (print_mask)      
         kfprintf(ascii_out,"MASK: %d elements",mask_e);
      kfprintf(ascii_out,"\n\n");

      print_types = KDCOMPLEX | KDOUBLE | KLONG | KULONG;
      if (print_location) 
      {
         loc_ptype = kdatatype_cast_process(loc_type, loc_type, print_types);
         kfprintf(ascii_out, 
	          "# Location data cast to type %s (%d) for printing\n", 
		  kdefine_to_datatype(loc_ptype), loc_ptype);
         if (!kpds_set_attributes(in_obj,
			KPDS_LOCATION_DATA_TYPE, loc_ptype,
			KPDS_LOCATION_POSITION, 0, 0, 0, 0,
			NULL)) 
	 {
            kerror(lib, prog, "Cannot set Location type & position attributes");
	    (void) kpds_close_object(in_obj);
            return(FALSE);
         }

	 /* 
	  *   PRINT LOCATION NOW if its rectilinear or curvilinear and
	  *   *only* the location data is to be printed.  Print the
	  *   data in a form which corresponds to the grid type.
	  *   Since this is the only output we need, we can go ahead
	  *   and return from here. 
	  */
	 if (print_location && !print_value && !print_time && !print_mask)
	 {
	    if (grid == KUNIFORM)
	    {
               /* -- Print Location Begin -- */
	       kfprintf(ascii_out,"\n# Location Begin:  ");
	       kpds_print_attribute(in_obj, KPDS_LOCATION_BEGIN, ascii_out);

	       /* -- Print Location End -- */
	       kfprintf(ascii_out,"\n# Location End:  ");
	       kpds_print_attribute(in_obj, KPDS_LOCATION_END, ascii_out);

	       kfprintf(ascii_out,"\n");

	       return(TRUE);
	    } 
	    else if (grid == KRECTILINEAR)
	    {
	       kaddr ldata = NULL;
	       
	       /* -- Print Location WIDTH data -- */
	       kfprintf(ascii_out,"\n# Location WIDTH: 1 value  ");
               for (w=0; w<loc_w; w++) 
	       {
		  if ((ldata = (kaddr) kpds_get_data(in_obj, 
						     KPDS_LOCATION_WIDTH_POINT,
						     ldata)) == NULL)
		  {
		     kerror(lib, prog, 
			    "Unable to read location width data.");
		     kfree(ldata);
		     (void) kpds_close_object(in_obj);
		     return(FALSE);
		  }
		
		  if (print_index)
		     kfprintf(ascii_out, "\n%d  ", w);
		  else
		     kfprintf(ascii_out, "\n");

		  if (loc_ptype == KDCOMPLEX) 
		  {
		     kdcomplex *cdata = (kdcomplex *) ldata;
		     
		     kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                              kdcreal(cdata[0]), kdcimag(cdata[0]));
		  }
		  else if (loc_ptype == KDOUBLE) 
		  {
		     double *cdata = (double *) ldata;
		     
		     kfprintf(ascii_out,"% 10.10lg  ", cdata[0]);
		  }
		  else if (loc_ptype == KLONG) 
		  {
		     long *cdata = (long *) ldata;

		     kfprintf(ascii_out,"%ld  ", cdata[0]);
		  }
		  else  /* KULONG */
		  {
		     unsigned long *cdata = (unsigned long *) ldata;
		     
		     kfprintf(ascii_out,"%lu  ", cdata[0]);
                  }
	       }
	       
	       /* -- Print Location HEIGHT data -- */
	       kfprintf(ascii_out,"\n\n# Location HEIGHT: 1 value  ");
               for (h=0; h<loc_h; h++) 
	       {
		  if ((ldata = (kaddr) kpds_get_data(in_obj, 
						    KPDS_LOCATION_HEIGHT_POINT,
						    ldata)) == NULL)
		  {
		     kerror(lib, prog, 
			    "Unable to read location height data.");
		     kfree(ldata);
		     (void) kpds_close_object(in_obj);
		     return(FALSE);
		  }

		  if (print_index)
		     kfprintf(ascii_out, "\n%d  ", h);
		  else
		     kfprintf(ascii_out, "\n");
		  
		  if (loc_ptype == KDCOMPLEX) 
		  {
		     kdcomplex *cdata = (kdcomplex *) ldata;
		     
		     kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                              kdcreal(cdata[0]), kdcimag(cdata[0]));
		  }
		  else if (loc_ptype == KDOUBLE) 
		  {
		     double *cdata = (double *) ldata;
		     
		     kfprintf(ascii_out,"% 10.10lg  ", cdata[0]);
		  }
		  else if (loc_ptype == KLONG) 
		  {
		     long *cdata = (long *) ldata;

		     kfprintf(ascii_out,"%ld  ", cdata[0]);
		  }
		  else  /* KULONG */
		  {
		     unsigned long *cdata = (unsigned long *) ldata;
		     
		     kfprintf(ascii_out,"%lu  ", cdata[0]);
                  }
	       }

	       /* -- Print Location DEPTH data -- */
	       kfprintf(ascii_out,"\n\n# Location DEPTH: 1 value  ");
               for (d=0; d<loc_d; d++) 
	       {
		  if ((ldata = (kaddr) kpds_get_data(in_obj, 
						     KPDS_LOCATION_DEPTH_POINT,
						     ldata)) == NULL)
		  {
		     kerror(lib, prog, 
			    "Unable to read location depth data.");
		     kfree(ldata);
		     (void) kpds_close_object(in_obj);
		     return(FALSE);
		  }
		  
		  if (print_index)
		     kfprintf(ascii_out, "\n%d  ", d);
		  else
		     kfprintf(ascii_out, "\n");
		  
		  if (loc_ptype == KDCOMPLEX) 
		  {
		     kdcomplex *cdata = (kdcomplex *) ldata;
		     
		     kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                              kdcreal(cdata[0]), kdcimag(cdata[0]));
		  }
		  else if (loc_ptype == KDOUBLE) 
		  {
		     double *cdata = (double *) ldata;
		     
		     kfprintf(ascii_out,"% 10.10lg  ", cdata[0]);
		  }
		  else if (loc_ptype == KLONG) 
		  {
		     long *cdata = (long *) ldata;

		     kfprintf(ascii_out,"%ld  ", cdata[0]);
		  }
		  else  /* KULONG */
		  {
		     unsigned long *cdata = (unsigned long *) ldata;
		     
		     kfprintf(ascii_out,"%lu  ", cdata[0]);
                  }
	       }
	       kfprintf(ascii_out,"\n");

	       /* -- END of RECTILINEAR printing -- */

	       return(TRUE);
	    }

	    /* go ahead and print it as curvilinear */
	 }

	 if (grid == KUNIFORM || grid == KRECTILINEAR)
            kfprintf(ascii_out, 
	          "# Location %s grid presented as Curvilinear grid "
	          "for printing\n", 
		  (grid == KUNIFORM) ? "Uniform" : "Rectilinear");

      }
      if (print_time) 
      {
         time_ptype = kdatatype_cast_process(time_type, time_type, print_types);
         kfprintf(ascii_out, 
	          "# Time data cast to type %s (%d) for printing\n", 
		  kdefine_to_datatype(time_ptype), time_ptype);
         if (!kpds_set_attributes(in_obj,
			KPDS_TIME_DATA_TYPE, time_ptype,
			KPDS_TIME_POSITION, 0,
			NULL)) 
	 {
            kerror(lib, prog, "Cannot set Time type & position attributes");
	    (void) kpds_close_object(in_obj);
            return(FALSE);
         }
      }
      if (print_value) 
      {
         val_ptype = kdatatype_cast_process(val_type, val_type, print_types);
         kfprintf(ascii_out, 
	          "# Value data cast to type %s (%d) for printing\n", 
		  kdefine_to_datatype(val_ptype), val_ptype);
         if (!kpds_set_attributes(in_obj, 
			KPDS_VALUE_DATA_TYPE, val_ptype,
			KPDS_VALUE_POSITION, 0, 0, 0, 0, 0,
			NULL)) 
	 {
            kerror(lib, prog, "Cannot set Value type & position attributes");
	    (void) kpds_close_object(in_obj);
            return(FALSE);
         }
      }
      if (print_mask) 
      {
         kfprintf(ascii_out, 
	          "# Mask data cast to type %s (%d) for printing\n", 
                   kdefine_to_datatype(mask_ptype), mask_ptype);

      }

      
      for (t=0; t<tim; t++) 
      {
         if (print_time) 
	 {
            if (time_ptype == KDCOMPLEX) 
	    {
               if ((ctime_data = kpds_get_data(in_obj,
                           	 KPDS_TIME_POINT,ctime_data)) == NULL) 
               {
	          kerror(lib, prog, 
			      "Unable to read double complex time data.");
		  (void) kpds_close_object(in_obj);
                  kfree(ctime_data);
                  return(FALSE);
               }
            }
            else if (time_ptype == KDOUBLE) 
	    {
               if ((ftime_data = kpds_get_data(in_obj,
                           	 KPDS_TIME_POINT,ftime_data)) == NULL) 
	       {
	          kerror(lib, prog, "Unable to read double time data.");
		  (void) kpds_close_object(in_obj);
                  kfree(ftime_data);
                  return(FALSE);
               }
            }
            else if (time_ptype == KLONG) 
	    {
               if ((itime_data = kpds_get_data(in_obj,
                           	 KPDS_TIME_POINT,itime_data)) == NULL) 
	       {
	          kerror(lib, prog, "Unable to read long time data.");
		  (void) kpds_close_object(in_obj);
                  kfree(itime_data);
                  return(FALSE);
               }
            }
            else 
	    { /* KULONG */
               if ((uitime_data = kpds_get_data(in_obj,
                           	  KPDS_TIME_POINT,uitime_data)) == NULL) 
	       {
		  kerror(lib, prog, "Unable to read unsigned long time data.");
		  (void) kpds_close_object(in_obj);
                  kfree(uitime_data);
                  return(FALSE);
               }
            }
         }

         if (print_time && !print_value && !print_mask && !print_location)
         {
	    if (print_index)
	       kfprintf(ascii_out,"%d ",t);
            if (time_ptype == KDCOMPLEX)
            {
               kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                        kdcreal(ctime_data[0]), kdcimag(ctime_data[0]));
            }
            else if (time_ptype == KDOUBLE)
            {
               kfprintf(ascii_out,"% 10.10lg  ", ftime_data[0]);
            }
            else if (time_ptype == KLONG)
            {
               kfprintf(ascii_out,"%ld  ", itime_data[0]);
            }
            else
            { /* KULONG */
               kfprintf(ascii_out,"%lu  ", uitime_data[0]);
            }
	    kfprintf(ascii_out,"\n");
         }

	 else
	 {
         for (d=0; d<depth; d++) 
	 {
            for (h=0; h<height; h++) 
	    {
               for (w=0; w<width; w++) 
	       {
                  if (print_index) 
		  {
                     if (tim    > 1)  kfprintf(ascii_out,"%d ",t);
                     if (depth  > 1)  kfprintf(ascii_out,"%d ",d);
         	     if (height > 1)  kfprintf(ascii_out,"%d ",h);
                     if (width  > 1)  kfprintf(ascii_out,"%d ",w);
                     kfprintf(ascii_out," ");
                  }
                  if (print_location) 
		  {
                     if (loc_ptype == KDCOMPLEX) 
		     {
                        if ((cloc_data = kpds_get_data(in_obj,
                           	KPDS_LOCATION_VECTOR,cloc_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read double complex location data.");
                           kfree(cloc_data);
			   (void) kpds_close_object(in_obj);
                           return(FALSE);
                        }
                        for (i=0; i<loc_n; i++) 
			{
                           kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                              kdcreal(cloc_data[i]), kdcimag(cloc_data[i]));
                        }
                     }
                     else if (loc_ptype == KDOUBLE) 
		     {
                        if ((floc_data = kpds_get_data(in_obj,
                           	KPDS_LOCATION_VECTOR,floc_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read double location data.");
			   (void) kpds_close_object(in_obj);
                           kfree(floc_data);
                           return(FALSE);
                        }
                        for (i=0; i<loc_n; i++) 
                           kfprintf(ascii_out,"% 10.10lg  ", floc_data[i]);
                     }
                     else if (loc_ptype == KLONG) 
		     {
                        if ((iloc_data = kpds_get_data(in_obj,
                           	KPDS_LOCATION_VECTOR,iloc_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read long location data.");
			   (void) kpds_close_object(in_obj);
                           kfree(iloc_data);
                           return(FALSE);
                        }
                        for (i=0; i<loc_n; i++) 
                           kfprintf(ascii_out,"%ld  ", iloc_data[i]);
		     }
                     else 
		     {  /* KULONG */
                        if ((uiloc_data = kpds_get_data(in_obj,
                           	KPDS_LOCATION_VECTOR,uiloc_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read unsigned long location data.");
			   (void) kpds_close_object(in_obj);
                           kfree(uiloc_data);
                           return(FALSE);
                        }
                        for (i=0; i<loc_n; i++) 
                           kfprintf(ascii_out,"%lu  ", uiloc_data[i]);
                     }
                  }


                  if (print_time)
		  {
                     if (time_ptype == KDCOMPLEX) 
		     {
                        kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
			   kdcreal(ctime_data[0]), kdcimag(ctime_data[0]));
                     }
                     else if (time_ptype == KDOUBLE) 
		     {
                        kfprintf(ascii_out,"% 10.10lg  ", ftime_data[0]);
                     }
                     else if (time_ptype == KLONG) 
		     {
                        kfprintf(ascii_out,"%ld  ", itime_data[0]);
                     }
                     else 
		     { /* KULONG */
                        kfprintf(ascii_out,"%lu  ", uitime_data[0]);
                     }
                  }
   
                  if (mask_av) {
                     if ((bmask_data = kpds_get_data(in_obj,
                        	KPDS_MASK_VECTOR, bmask_data)) == NULL) 
		     {
		        kerror(lib, prog, 
				"Unable to read unsigned byte mask data.");
			(void) kpds_close_object(in_obj);
                        kfree(bmask_data);
                        return(FALSE);
                     }
                  }
   
                  if (print_value) {
                     if (val_ptype == KDCOMPLEX) 
		     {
                        if ((cval_data = kpds_get_data(in_obj,
                           	KPDS_VALUE_VECTOR, cval_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read double complex value data.");
			   (void) kpds_close_object(in_obj);
                           kfree(cval_data);
                           return(FALSE);
                        }
                        for (i=0; i<val_e; i++) 
			{
                           if (replace_flag && (bmask_data[i] == 0)) 
			   {
                              kfprintf(ascii_out,"(%s, %s)  ",replace_string, 
                                    replace_string);
                           }
			   else 
			   {
                              kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                                 kdcreal(cval_data[i]), kdcimag(cval_data[i]));
                           }
                        }
                     }
                     else if (val_ptype == KDOUBLE) 
		     {
                        if ((fval_data = kpds_get_data(in_obj,
                           	KPDS_VALUE_VECTOR,fval_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read double value data.");
                           kfree(fval_data);
			   (void) kpds_close_object(in_obj);
                           return(FALSE);
                        }
                        for (i=0; i<val_e; i++) 
			{
                           if (replace_flag && (bmask_data[i] == 0)) 
                              kfprintf(ascii_out,"%s  ", replace_string);
			   else 
                              kfprintf(ascii_out,"% 10.10lg  ", fval_data[i]);
                        }
                     }
                     else if (val_ptype == KLONG) 
		     {
                        if ((ival_data = kpds_get_data(in_obj,
                           	KPDS_VALUE_VECTOR,ival_data)) == NULL) 
			{
			   kerror(lib, prog, "Unable to read long value data.");
                           kfree(ival_data);
			   (void) kpds_close_object(in_obj);
                           return(FALSE);
                        }
                        for (i=0; i<val_e; i++) 
			{
                           if (replace_flag && (bmask_data[i] == 0)) 
                              kfprintf(ascii_out,"%s  ", replace_string);
			   else 
                              kfprintf(ascii_out,"%ld  ", ival_data[i]);
                        }
                     }
                     else 
		     {  /* KULONG */
                        if ((uival_data = kpds_get_data(in_obj,
                           	KPDS_VALUE_VECTOR, uival_data)) == NULL) 
			{
			   kerror(lib, prog, 
				"Unable to read unsigned long value data.");
                           kfree(uival_data);
			   (void) kpds_close_object(in_obj);
                           return(FALSE);
                        }
                        for (i=0; i<val_e; i++) 
			{
                           if (replace_flag && (bmask_data[i] == 0)) 
                              kfprintf(ascii_out,"%s  ", replace_string);
			   else 
                              kfprintf(ascii_out,"%lu  ", uival_data[i]);
                        }
                     }
                  }
   
                  if (print_mask) {
                     for (i=0; i<mask_e; i++) {
                        kfprintf(ascii_out,"%d  ", bmask_data[i]);
                     }
                  }
                  kfprintf(ascii_out,"\n");
               }
            }
         }
      }
      }
      kfree(cloc_data); kfree(floc_data); 
      kfree(iloc_data); kfree(uiloc_data);
      kfree(ctime_data); kfree(ftime_data); 
      kfree(itime_data); kfree(uitime_data);
      kfree(bmask_data);  
      kfree(cval_data); kfree(fval_data); 
      kfree(ival_data); kfree(uival_data);
   }


   if (print_map && map_av) {

      /* Print header describing data output */
      kfprintf(ascii_out,
         "\n# Map Data Printed in the Following Format\n# ");
      if (print_map_index) {
         kfprintf(ascii_out,"MAP INDEX: ");
         if (map_e > 1)
            kfprintf(ascii_out,"e ");
         if (map_t > 1)
            kfprintf(ascii_out,"t ");
         if (map_d > 1)
            kfprintf(ascii_out,"d ");
         if (map_h > 1)
            kfprintf(ascii_out,"h ");
         kfprintf(ascii_out,"  ");
      }
      kfprintf(ascii_out,"MAP WIDTH: %d values\n\n",map_w);

      print_types = KDCOMPLEX | KDOUBLE | KLONG | KULONG;
      map_ptype = kdatatype_cast_process(map_type, map_type, print_types);
      kfprintf(ascii_out, "# Map data cast to type %s (%d) for printing\n", 
	       kdefine_to_datatype(map_ptype), map_ptype);
      if (!kpds_set_attributes(in_obj, 
			KPDS_MAP_DATA_TYPE, map_ptype,
			KPDS_MAP_POSITION, 0, 0, 0, 0, 0,
			NULL))
      {
         kerror(lib, prog, "Cannot set Map type & position attributes");
         (void) kpds_close_object(in_obj);
         return(FALSE);
      }
      
      for (e=0; e<map_e; e++) {
         for (t=0; t<map_t; t++) {
            for (s=0; s<map_d; s++) {
               for (h=0; h<map_h; h++) {
                  if (print_map_index) {
         	     if (map_e > 1)  kfprintf(ascii_out,"%d ",e);
                     if (map_t > 1)  kfprintf(ascii_out,"%d ",t);
                     if (map_d > 1)  kfprintf(ascii_out,"%d ",s);
                     if (map_h > 1)  kfprintf(ascii_out,"%d ",h);
                     kfprintf(ascii_out," ");
                  }
                  if (map_ptype == KDCOMPLEX) {
                     if ((cmap_data = kpds_get_data(in_obj,
                        	KPDS_MAP_LINE,cmap_data)) == NULL) 
		     {
		        kerror(lib, prog, 
				"Unable to read double complex map data.");
                        kfree(cmap_data);
			(void) kpds_close_object(in_obj);
                        return(FALSE);
                     }
                     for (i=0; i<map_w; i++) 
		     {
                        kfprintf(ascii_out,"(% 10.10lg, % 10.10lg)  ",
                           kdcreal(cmap_data[i]), kdcimag(cmap_data[i]));
                     }
                  }
                  else if (map_ptype == KDOUBLE) {
                     if ((fmap_data = kpds_get_data(in_obj,
                        	KPDS_MAP_LINE, fmap_data)) == NULL) 
		     {
		        kerror(lib, prog, 
				"Unable to read double map data.");
                        kfree(fmap_data);
			(void) kpds_close_object(in_obj);
                        return(FALSE);
                     }
                     for (i=0; i<map_w; i++) 
                        kfprintf(ascii_out,"%g  ", fmap_data[i]);
                  }
                  else if (map_ptype == KLONG)
		  {
                     if ((imap_data = kpds_get_data(in_obj,
                        	KPDS_MAP_LINE, imap_data)) == NULL) 
		     {
		        kerror(lib, prog, 
				"Unable to read long map data.");
                        kfree(imap_data);
			(void) kpds_close_object(in_obj);
                        return(FALSE);
                     }
                     for (i=0; i<map_w; i++) 
                        kfprintf(ascii_out,"%ld  ", imap_data[i]);
                  }
                  else {  /* KULONG */
                     if ((uimap_data = kpds_get_data(in_obj,
                        	KPDS_MAP_LINE, uimap_data)) == NULL) 
		     {
		        kerror(lib, prog, 
				"Unable to read unsigned long map data.");
                        kfree(uimap_data);
			(void) kpds_close_object(in_obj);
                        return(FALSE);
                     }
                     for (i=0; i<map_w; i++) 
                        kfprintf(ascii_out,"%lu  ", uimap_data[i]);
                  }
		  kfprintf(ascii_out,"\n");
               }
            }
         }
      }
      kfree(cmap_data); kfree(fmap_data); 
      kfree(imap_data); kfree(uimap_data);
   }

   return(TRUE);
}
/* -library_code_end */
