 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for klogexp
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lklogexp
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lklogexp - perform log or antilog function on data object
* 
*       Purpose: Library Routine for klogexp
*                The following is the library routine that performs
*                a log/antilog function on a data object. The routine
*                takes an input data object, user specified base,
*                offset flag, and an output data object
*                in which to store the result of the function.
*                
*                Therefore if lklogexp() were called with:
*
*                !       lklogexp(i, 2.0, TRUE, FALSE, o);
*
*                !       o = log2(i)
*
*                Therefore if lklogexp() were called with:
*
*                !       lklogexp(i, KE, FALSE, TRUE, o);
*
*                !       o = e**(i)-1
*
*         Input: i        - the input object to be processed
*                base     - the log/anti-log base if function is NULL
*                offset   - whether to subtract/add 1 from the result
*
*        Output: o        - the output object
*
*       Returns: TRUE (1) on success, FALSE (0) on failure
*  Restrictions: 
*    Written By: Donna Koechner, Mark Young, & Ashish Malhotra
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lklogexp (
   kobject i,
   double  base,
   int     offset,
   int     inv,
   kobject o)
/* -library_def_end */

/* -library_code */
{
        double *d_data = NULL;
        int   j, num;
        int   num_lines, line_size;

        if ((i = kpds_reference_object(i)) == KOBJECT_INVALID)
        {
           kerror("kdatamanip", "lklogexp", "failed to reference input object");
           return(FALSE);
        }

        kpds_set_attribute(o, KPDS_VALUE_DATA_TYPE, KDOUBLE);
        if ((o = kpds_reference_object(o)) == KOBJECT_INVALID)
        {
           (void) kpds_close_object(i);
           kerror("kdatamanip", "lklogexp",
                  "failed to reference output object");
           return(FALSE);
        }

        /*
         *  Set data type to be used in processing for both i and o.
         */ 
        kpds_set_attribute(i, KPDS_VALUE_DATA_TYPE, KDOUBLE);

	 if (base <= 0.0)
	 {
            (void) kpds_close_object(i);
            (void) kpds_close_object(o);
            kerror("kdatamanip", "lklogexp",
		   "Sorry, but the base '%g' must be greater than 0",base);
	    return(FALSE);
	 }

         if ( !inv )
         {
            base = klog(base);
         }

        /*
         *  Do the processing by simply requesting the lines of data from
         *  i and then evaluate the expression and then storing the
         *  result into the output.
         */

         kpds_get_attribute(i,KPDS_VALUE_LINE_INFO,&line_size,&num_lines);

         for (num = 0; num < num_lines; num++)
         {
             d_data = (double *) kpds_get_data(i, KPDS_VALUE_LINE,
                                (kaddr) d_data);

             if (offset)
             {
                if (inv)
                {
                   for (j = 0; j < line_size; j++)
                       d_data[j] = kpow(base, d_data[j]) - 1.0;
                }
                else
                {
                   for (j = 0; j < line_size; j++)
                      d_data[j] = (d_data[j] > -1.0) ? klog(d_data[j] + 1)/base:
                                             KMAXFLOAT;
                }
             }
             else
             {    
                if (inv)
                {
                   for (j = 0; j < line_size; j++)
                       d_data[j] = kpow(base, d_data[j]);
                }
                else
                {
                   for (j = 0; j < line_size; j++)
                       d_data[j] =  (d_data[j] > 0.0) ? klog(d_data[j])/base :
                                              KMAXFLOAT;
                }
             }  

             if (!kpds_put_data(o, KPDS_VALUE_LINE, d_data))
             {
               (void) kpds_close_object(i);
               (void) kpds_close_object(o);
               kfree(d_data);
               kerror("kdatamanip", "lklogexp",
		      "failed to put line in output object");
               return(FALSE);
             }
         }

         (void) kpds_close_object(i);
         (void) kpds_close_object(o);
         kfree(d_data);
         return(TRUE);
}
/* -library_code_end */
