 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ksetdattr
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ksetdattr_h_
#define _ksetdattr_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/ksetdattr/uis/ksetdattr.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  First Input data object (required infile)
 */
char	*i_file;	/* First Input data object FILENAME */
int	 i_flag;	/* First Input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  Set the KPDS_MASKED_VALUE_PRESENTATION attribute (Optional list)
 */
int	 maskpres_list;	/* Set the KPDS_MASKED_VALUE_PRESENTATION attribute LIST INDEX */
char	 *maskpres_label;	/* Set the KPDS_MASKED_VALUE_PRESENTATION attribute LIST LABEL */
int	 maskpres_flag;	/* Set the KPDS_MASKED_VALUE_PRESENTATION attribute FLAG */

/*
 *  Explicit Location Begin for width dimension (optional double)
 */
double	 wbegin_double;	/* Explicit Location Begin for width dimension DOUBLE */
int	 wbegin_flag;   	/* Explicit Location Begin for width dimension FLAG */

/*
 *  Explicit Location End for width dimension (optional double)
 */
double	 wend_double;	/* Explicit Location End for width dimension DOUBLE */
int	 wend_flag;   	/* Explicit Location End for width dimension FLAG */

/*
 *  Explicit Location Begin for height dimension (optional double)
 */
double	 hbegin_double;	/* Explicit Location Begin for height dimension DOUBLE */
int	 hbegin_flag;   	/* Explicit Location Begin for height dimension FLAG */

/*
 *  Explicit Location End for height dimension (optional double)
 */
double	 hend_double;	/* Explicit Location End for height dimension DOUBLE */
int	 hend_flag;   	/* Explicit Location End for height dimension FLAG */

/*
 *  Explicit Location Begin for depth dimension (optional double)
 */
double	 dbegin_double;	/* Explicit Location Begin for depth dimension DOUBLE */
int	 dbegin_flag;   	/* Explicit Location Begin for depth dimension FLAG */

/*
 *  Explicit Location End for depth dimension (optional double)
 */
double	 dend_double;	/* Explicit Location End for depth dimension DOUBLE */
int	 dend_flag;   	/* Explicit Location End for depth dimension FLAG */

/*
 *  Sub-object width position with respect to parent object (optional integer)
 */
int	 wpos_int; 	/* Sub-object width position with respect to parent object INT */
int	 wpos_flag;	/* Sub-object width position with respect to parent object FLAG */

/*
 *  World coordinate point size in width dimension (optional double)
 */
double	 wpsize_double;	/* World coordinate point size in width dimension DOUBLE */
int	 wpsize_flag;   	/* World coordinate point size in width dimension FLAG */

/*
 *  Sub-object height position with respect to parent object (optional integer)
 */
int	 hpos_int; 	/* Sub-object height position with respect to parent object INT */
int	 hpos_flag;	/* Sub-object height position with respect to parent object FLAG */

/*
 *  World coordinate point size in height dimension (optional double)
 */
double	 hpsize_double;	/* World coordinate point size in height dimension DOUBLE */
int	 hpsize_flag;   	/* World coordinate point size in height dimension FLAG */

/*
 *  Sub-object depth position with respect to parent object (optional integer)
 */
int	 dpos_int; 	/* Sub-object depth position with respect to parent object INT */
int	 dpos_flag;	/* Sub-object depth position with respect to parent object FLAG */

/*
 *  World coordinate point size in depth dimension (optional double)
 */
double	 dpsize_double;	/* World coordinate point size in depth dimension DOUBLE */
int	 dpsize_flag;   	/* World coordinate point size in depth dimension FLAG */

/*
 *  Sub-object time position with respect to parent object (optional integer)
 */
int	 tpos_int; 	/* Sub-object time position with respect to parent object INT */
int	 tpos_flag;	/* Sub-object time position with respect to parent object FLAG */

/*
 *  World coordinate point size in time dimension (optional double)
 */
double	 tpsize_double;	/* World coordinate point size in time dimension DOUBLE */
int	 tpsize_flag;   	/* World coordinate point size in time dimension FLAG */

/*
 *  Sub-object elements position with respect to parent object (optional integer)
 */
int	 epos_int; 	/* Sub-object elements position with respect to parent object INT */
int	 epos_flag;	/* Sub-object elements position with respect to parent object FLAG */

/*
 *  World coordinate point size in elements dimension (optional double)
 */
double	 epsize_double;	/* World coordinate point size in elements dimension DOUBLE */
int	 epsize_flag;   	/* World coordinate point size in elements dimension FLAG */

/*
 *  Set the KCOLOR_COLORSPACE attribute (Optional list)
 */
int	 cspace_list;	/* Set the KCOLOR_COLORSPACE attribute LIST INDEX */
char	 *cspace_label;	/* Set the KCOLOR_COLORSPACE attribute LIST LABEL */
int	 cspace_flag;	/* Set the KCOLOR_COLORSPACE attribute FLAG */

/*
 *  Set the KCOLOR_HAS_ALPHA attribute (Optional list)
 */
int	 alpha_list;	/* Set the KCOLOR_HAS_ALPHA attribute LIST INDEX */
char	 *alpha_label;	/* Set the KCOLOR_HAS_ALPHA attribute LIST LABEL */
int	 alpha_flag;	/* Set the KCOLOR_HAS_ALPHA attribute FLAG */

/*----- optional   group ----*/
/*
 *  Set the real component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  (optional double)
 */
double	 rmasksub_double;	/* Set the real component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  DOUBLE */
int	 rmasksub_flag;   	/* Set the real component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  FLAG */

/*
 *  Set the imaginary component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  (optional double)
 */
double	 imasksub_double;	/* Set the imaginary component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  DOUBLE */
int	 imasksub_flag;   	/* Set the imaginary component of the KPDS_MASK_SUBSTITUTE_VALUE attribute  FLAG */

/*-- optional   group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ksetdattr_get_args PROTO((kform *));
void ksetdattr_usage_additions PROTO((void));
void ksetdattr_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
