 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ksampline
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ksampline.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Sample a data object along an arbitrary line
|
|       Purpose: main program for ksampline
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->wc1_double; {coordinate of start of line along W axis}
|		int    clui_info->wc1_flag; {TRUE if -wc1 specified}
|
|		double clui_info->wc2_double; {coordinate of end of line along W axis}
|		int    clui_info->wc2_flag; {TRUE if -wc2 specified}
|
|		double clui_info->hc1_double; {coordinate of start of line along H axis}
|		int    clui_info->hc1_flag; {TRUE if -hc1 specified}
|
|		double clui_info->hc2_double; {coordinate of end of line along H axis}
|		int    clui_info->hc2_flag; {TRUE if -hc2 specified}
|
|		double clui_info->dc1_double; {coordinate of start of line along D axis}
|		int    clui_info->dc1_flag; {TRUE if -dc1 specified}
|
|		double clui_info->dc2_double; {coordinate of end of line along D axis}
|		int    clui_info->dc2_flag; {TRUE if -dc2 specified}
|
|		double clui_info->tc1_double; {coordinate of start of line along T axis}
|		int    clui_info->tc1_flag; {TRUE if -tc1 specified}
|
|		double clui_info->tc2_double; {coordinate of end of line along T axis}
|		int    clui_info->tc2_flag; {TRUE if -tc2 specified}
|
|		double clui_info->ec1_double; {coordinate of start of line along E axis}
|		int    clui_info->ec1_flag; {TRUE if -ec1 specified}
|
|		double clui_info->ec2_double; {coordinate of end of line along E axis}
|		int    clui_info->ec2_flag; {TRUE if -ec2 specified}
|
|		int clui_info->n_int; {number of samples (including endpoints)}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		int clui_info->nc_int; {minimum required neighbor count}
|		int clui_info->nc_flag; {TRUE if -nc specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj,out_obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(ksampline_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "ksampline",
		ksampline_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ksampline_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
          {
            kerror("ksampline","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }

        if (clui_info->i_flag)
          {
            if ((in_obj = kpds_open_input_object(clui_info->i_file))
                    == KOBJECT_INVALID)
              {
                kerror("ksampline","main", "Cannot open input object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj, out_obj))
              {
                kerror("ksampline","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lksampline(in_obj,
                     clui_info->wc1_double,
                     clui_info->hc1_double,
                     clui_info->dc1_double,
                     clui_info->tc1_double,
                     clui_info->ec1_double,
                     clui_info->wc2_double,
                     clui_info->hc2_double,
                     clui_info->dc2_double,
                     clui_info->tc2_double,
                     clui_info->ec2_double,
                     clui_info->n_int,
                     clui_info->nc_int,
                     out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("ksampline", "main","Unable to set history on output object"
);
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
        kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ksampline_usage_additions
| 
|       Purpose: Prints usage additions in ksampline_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksampline
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksampline_usage_additions(void)
{
	kfprintf(kstderr, "\tSample a data object along an arbitrary line\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ksampline_free_args
| 
|       Purpose: Frees CLUI struct allocated in ksampline_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksampline
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ksampline_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
