 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kprdata.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kprdata_get_args
| 
|       Purpose: Gets command line args for kprdata
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprdata
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kprdata_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kprdata is out of sync with arguments specified in kprdata's *.pane file; please rerun ghostwriter on kprdata.";


	/*
	 * allocate the kprdata structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "attr",
			  &(clui_info->attr_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "loc",
			  &(clui_info->loc_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "time",
			  &(clui_info->time_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "val",
			  &(clui_info->val_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mask",
			  &(clui_info->mask_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ind",
			  &(clui_info->ind_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "replace",
			  &(clui_info->replace_string),
			  &(clui_info->replace_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "f",
			  &(clui_info->f_file),
			  &(clui_info->f_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mind",
			  &(clui_info->mind_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "map",
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mval",
			  &(clui_info->mval_flag))))
	{
	    kerror(NULL, "kprdata_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



