 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for knoise
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _knoise_h_
#define _knoise_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/knoise/uis/knoise.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input file (required infile)
 */
char	*i_file;	/* input file FILENAME */
int	 i_flag;	/* input file FLAG */

/*
 *  output file (required outfile)
 */
char	*o_file;	/* output file FILENAME */
int	 o_flag;	/* output file FLAG */

/*----- required ME group ----*/
/*
 *  Replace existing values with noise (optional flag)
 */
int	 replace_flag;  	/* Replace existing values with noise FLAG */

/*
 *  Add noise to the specified segment (optional flag)
 */
int	 add_flag;  	/* Add noise to the specified segment FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  Generate Gaussian noise (optional flag)
 */
int	 gauss_flag;  	/* Generate Gaussian noise FLAG */

/*
 *  Mean for Gaussian noise (optional double)
 */
double	 gmean_double;	/* Mean for Gaussian noise DOUBLE */
int	 gmean_flag;   	/* Mean for Gaussian noise FLAG */

/*
 *  Variance for Gaussian noise (optional double)
 */
double	 gvar_double;	/* Variance for Gaussian noise DOUBLE */
int	 gvar_flag;   	/* Variance for Gaussian noise FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Generate Rayleigh Noise (optional flag)
 */
int	 ray_flag;  	/* Generate Rayleigh Noise FLAG */

/*
 *  Variance for Rayleigh noise (optional double)
 */
double	 rvar_double;	/* Variance for Rayleigh noise DOUBLE */
int	 rvar_flag;   	/* Variance for Rayleigh noise FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Generate uniformly distributed noise (optional flag)
 */
int	 unif_flag;  	/* Generate uniformly distributed noise FLAG */

/*
 *  Maximum value for uniform distribution (optional double)
 */
double	 umax_double;	/* Maximum value for uniform distribution DOUBLE */
int	 umax_flag;   	/* Maximum value for uniform distribution FLAG */

/*
 *  Minimum value for uniform noise (optional double)
 */
double	 umin_double;	/* Minimum value for uniform noise DOUBLE */
int	 umin_flag;   	/* Minimum value for uniform noise FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Generate Poisson Noise (optional flag)
 */
int	 poiss_flag;  	/* Generate Poisson Noise FLAG */

/*
 *  Amount of time (optional double)
 */
double	 ptime_double;	/* Amount of time DOUBLE */
int	 ptime_flag;   	/* Amount of time FLAG */

/*
 *  Variance for Poisson distribution (optional double)
 */
double	 pvar_double;	/* Variance for Poisson distribution DOUBLE */
int	 pvar_flag;   	/* Variance for Poisson distribution FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Generate exponential noise (optional flag)
 */
int	 exp_flag;  	/* Generate exponential noise FLAG */

/*
 *  Variance for exponential distribution (optional double)
 */
double	 evar_double;	/* Variance for exponential distribution DOUBLE */
int	 evar_flag;   	/* Variance for exponential distribution FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void knoise_get_args PROTO((kform *));
void knoise_usage_additions PROTO((void));
void knoise_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
