 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for klogexp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "klogexp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Logarithm and Exponential (Antilogarithm)
|
|       Purpose: main program for klogexp
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->be_flag; {TRUE if -be specified}
|
|		    int clui_info->b10_flag; {TRUE if -b10 specified}
|
|		    int clui_info->b2_flag; {TRUE if -b2 specified}
|
|		    double clui_info->base_double; {User Specified base}
|		    int    clui_info->base_flag; {TRUE if -base specified}
|
|		int clui_info->inv_flag; {TRUE if -inv specified}
|
|		int clui_info->offset_logic; {Operate either on value [False] or value+1 for log and value -1 for antilog [True]}
|		int clui_info->offset_flag; {TRUE if -offset specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Mark Young, & Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj = NULL;
        kobject out_obj = NULL;
        double  base=10.0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(klogexp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "klogexp",
		klogexp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	klogexp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) 
	   == KOBJECT_INVALID)
	{
	   kerror("klogexp", "main", "failed to open input object.");
	   kexit(KEXIT_FAILURE);
	}
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
	   == KOBJECT_INVALID)
	{
	   kpds_close_object(in_obj);
	   kerror("klogexp", "main", "failed to open input object.");
           kexit(KEXIT_FAILURE);
	}
	
	if (!kpds_copy_object_attr(in_obj, out_obj))
	{
	   kerror("klogexp", "main", 
		  "unable to copy attributes from input object to output.");
           kexit(KEXIT_FAILURE);
	}
	

        if(clui_info->be_flag)
           base = (double)KE;
        else if(clui_info->b10_flag)
           base = (double)10.0;
        else if(clui_info->b2_flag)
           base = (double)2.0;
        else if(clui_info->base_flag)
           base = clui_info->base_double;
	else
	{
	   kerror("klogexp", "main", "base not specified.");
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lklogexp(in_obj, base, clui_info->offset_logic,
                      clui_info->inv_flag, out_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("klogexp", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	if (!kpds_copy_remaining_data(in_obj, out_obj))
	{
	   kerror("klogexp", "main", 
		  "unable to copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
	}
	
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: klogexp_usage_additions
| 
|       Purpose: Prints usage additions in klogexp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klogexp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void klogexp_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Logarithm and Exponential (Antilogarithm)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: klogexp_free_args
| 
|       Purpose: Frees CLUI struct allocated in klogexp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klogexp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
klogexp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
