 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "klocxform.h"
/*-----------------------------------------------------------
| 
|  Routine Name: klocxform_get_args
| 
|       Purpose: Gets command line args for klocxform
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klocxform
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void klocxform_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for klocxform is out of sync with arguments specified in klocxform's *.pane file; please rerun ghostwriter on klocxform.";


	/*
	 * allocate the klocxform structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "xrot",
			  &(clui_info->xrot_float),
			  &(clui_info->xrot_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "yrot",
			  &(clui_info->yrot_float),
			  &(clui_info->yrot_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "zrot",
			  &(clui_info->zrot_float),
			  &(clui_info->zrot_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "fx",
			  &(clui_info->fx_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "xtrans",
			  &(clui_info->xtrans_float),
			  &(clui_info->xtrans_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "fy",
			  &(clui_info->fy_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "ytrans",
			  &(clui_info->ytrans_float),
			  &(clui_info->ytrans_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "fz",
			  &(clui_info->fz_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "ztrans",
			  &(clui_info->ztrans_float),
			  &(clui_info->ztrans_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "scale",
			  &(clui_info->scale_float),
			  &(clui_info->scale_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "xscale",
			  &(clui_info->xscale_float),
			  &(clui_info->xscale_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "yscale",
			  &(clui_info->yscale_float),
			  &(clui_info->yscale_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "zscale",
			  &(clui_info->zscale_float),
			  &(clui_info->zscale_flag))))
	{
	    kerror(NULL, "klocxform_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



