 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kinset
   >>>> 
   >>>>    Written By: Donna Koechner and Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kinset_h_
#define _kinset_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kinset/uis/kinset.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Base input image (required infile)
 */
char	*i1_file;	/* Base input image FILENAME */
int	 i1_flag;	/* Base input image FLAG */

/*
 *  Second (inset) input image (required infile)
 */
char	*i2_file;	/* Second (inset) input image FILENAME */
int	 i2_flag;	/* Second (inset) input image FLAG */

/*
 *  Resulting output object (required outfile)
 */
char	*o_file;	/* Resulting output object FILENAME */
int	 o_flag;	/* Resulting output object FLAG */

/*
 *  If Object has Mask, Only Inset VALID DataIf (optional logical)
 */
int	 insetvalid_logic;	/* If Object has Mask, Only Inset VALID DataIf LOGIC */
int	 insetvalid_flag;  	/* If Object has Mask, Only Inset VALID DataIf FLAG */

/*
 *  Real constant pad level (optional double)
 */
double	 real_double;	/* Real constant pad level DOUBLE */
int	 real_flag;   	/* Real constant pad level FLAG */

/*
 *  Imaginary constant pad level (optional double)
 */
double	 imag_double;	/* Imaginary constant pad level DOUBLE */
int	 imag_flag;   	/* Imaginary constant pad level FLAG */

/*
 *  Identify padded data added by this program as valid or invalid in mask (optional logical)
 */
int	 padvalid_logic;	/* Identify padded data added by this program as valid or invalid in mask LOGIC */
int	 padvalid_flag;  	/* Identify padded data added by this program as valid or invalid in mask FLAG */

/*
 *  Defines map treatment when some, but not all, objects have maps  (Optional list)
 */
int	 mapping_list;	/* Defines map treatment when some, but not all, objects have maps  LIST INDEX */
char	 *mapping_label;	/* Defines map treatment when some, but not all, objects have maps  LIST LABEL */
int	 mapping_flag;	/* Defines map treatment when some, but not all, objects have maps  FLAG */

/*----- optional   group ----*/
/*
 *  Insert at i2 subobject position (attribute) - w,h,d,t,e will override if specified (optional flag)
 */
int	 attr_flag;  	/* Insert at i2 subobject position (attribute) - w,h,d,t,e will override if specified FLAG */

/*
 *  Insert region beginning at this width coordinate (optional integer)
 */
int	 woff_int; 	/* Insert region beginning at this width coordinate INT */
int	 woff_flag;	/* Insert region beginning at this width coordinate FLAG */

/*
 *  Insert region beginning at this height coordinate (optional integer)
 */
int	 hoff_int; 	/* Insert region beginning at this height coordinate INT */
int	 hoff_flag;	/* Insert region beginning at this height coordinate FLAG */

/*
 *  Insert region beginning at this depth coordinate (optional integer)
 */
int	 doff_int; 	/* Insert region beginning at this depth coordinate INT */
int	 doff_flag;	/* Insert region beginning at this depth coordinate FLAG */

/*
 *  Insert region beginning at this time coordinate (optional integer)
 */
int	 toff_int; 	/* Insert region beginning at this time coordinate INT */
int	 toff_flag;	/* Insert region beginning at this time coordinate FLAG */

/*
 *  Insert region beginning at this element coordinate (optional integer)
 */
int	 eoff_int; 	/* Insert region beginning at this element coordinate INT */
int	 eoff_flag;	/* Insert region beginning at this element coordinate FLAG */

/*-- optional   group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kinset_get_args PROTO((kform *));
void kinset_usage_additions PROTO((void));
void kinset_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
