 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kinsertseg
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kinsertseg.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Insert Selected Data Segments from Input 1 into Input 2
|
|       Purpose: main program for kinsertseg
|
|         Input:
|		char *clui_info->i1_file; {Source Input File}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Destination Input File}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->loc_flag; {TRUE if -loc specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    char *clui_info->segment_string; {Perform operation on user specified segment}
|		    int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas & Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        char    *segment_list=NULL;
        int     insert_all = FALSE;
        kobject source_object1=NULL, 
		source_object2=NULL, 
		destination_object=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kinsertseg_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kinsertseg",
		kinsertseg_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kinsertseg_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Instantiate objects.
         */
        if ( (source_object1 = kdms_open(clui_info->i1_file,
                                        KOBJ_READ)) == NULL) {
           kerror("kinsertseg", "main",
                  "Failed to open first input object");
           kexit(KEXIT_FAILURE);
        }
 
        if ( (source_object2 = kdms_open(clui_info->i2_file,
                                         KOBJ_READ)) == NULL) {
           kerror("kinsertseg", "main",
                  "Failed to open second input object");
           kexit(KEXIT_FAILURE);
        }
 
        if ((destination_object=kdms_open(clui_info->o_file,
                                       KOBJ_WRITE)) == NULL) {
           kerror("kinsertseg", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * If the -segment option specified see if its value is "Delete All".
         * If it is insert all the segments.  If not create the segment_list.
         */
        if ( clui_info->segment_flag ) {
           if ( kstrstr(clui_info->segment_string, "Insert All") ) {
              if (!lkinsertseg(source_object1, source_object2,
                                    NULL, destination_object)) {
                 kexit(KEXIT_FAILURE);
              }
              insert_all = TRUE;
           }
           else {
              segment_list =
                 kstring_cat(clui_info->segment_string, " ", NULL);
           }
        }
 
        /*
         * Now check for all the polymorphic segment if we did not
         * already try to insert all the data already and append them
         * to the segment_list.
         */
        if ( !insert_all && clui_info->val_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_VALUE, " ", NULL);
        }
 
        if ( !insert_all && clui_info->mask_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_MASK, " ", NULL);
        }
 
        if ( !insert_all && clui_info->map_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_MAP, " ", NULL);
        }
 
        if ( !insert_all && clui_info->loc_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_LOCATION, " ", NULL);
        }

        if ( !insert_all && clui_info->time_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_TIME, " ", NULL);
        }
 
        /*
         * If we have not tried to insert all the segment, insert
         * the segments on the segment_list.
         */
        if ( !insert_all &&
             !lkinsertseg(source_object1, source_object2,
                               segment_list, destination_object)) {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kinsertseg", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kinsertseg_usage_additions
| 
|       Purpose: Prints usage additions in kinsertseg_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinsertseg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kinsertseg_usage_additions(void)
{
	kfprintf(kstderr, "\tInsert Selected Data Segments from Input 1 into Input 2\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kinsertseg_free_args
| 
|       Purpose: Frees CLUI struct allocated in kinsertseg_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinsertseg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kinsertseg_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
