 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kimpulse
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kimpulse_h_
#define _kimpulse_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kimpulse/uis/kimpulse.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Output file containing impulse value data (required outfile)
 */
char	*o_file;	/* Output file containing impulse value data FILENAME */
int	 o_flag;	/* Output file containing impulse value data FLAG */

/*
 *  Width of impulse value data (optional integer)
 */
int	 wsize_int; 	/* Width of impulse value data INT */
int	 wsize_flag;	/* Width of impulse value data FLAG */

/*
 *  Number of impulses generated along the width dimension (optional integer)
 */
int	 wnum_int; 	/* Number of impulses generated along the width dimension INT */
int	 wnum_flag;	/* Number of impulses generated along the width dimension FLAG */

/*
 *  Height of impulse value data (optional integer)
 */
int	 hsize_int; 	/* Height of impulse value data INT */
int	 hsize_flag;	/* Height of impulse value data FLAG */

/*
 *  Number of impulses generated along the height dimension (optional integer)
 */
int	 hnum_int; 	/* Number of impulses generated along the height dimension INT */
int	 hnum_flag;	/* Number of impulses generated along the height dimension FLAG */

/*
 *  Depth of impulse value data (optional integer)
 */
int	 dsize_int; 	/* Depth of impulse value data INT */
int	 dsize_flag;	/* Depth of impulse value data FLAG */

/*
 *  Number of impulses generated along the depth dimension (optional integer)
 */
int	 dnum_int; 	/* Number of impulses generated along the depth dimension INT */
int	 dnum_flag;	/* Number of impulses generated along the depth dimension FLAG */

/*
 *  Time of impulse value data (optional integer)
 */
int	 tsize_int; 	/* Time of impulse value data INT */
int	 tsize_flag;	/* Time of impulse value data FLAG */

/*
 *  Number of impulses generated along the time dimension (optional integer)
 */
int	 tnum_int; 	/* Number of impulses generated along the time dimension INT */
int	 tnum_flag;	/* Number of impulses generated along the time dimension FLAG */

/*
 *  Element dimension of impulse value data (optional integer)
 */
int	 esize_int; 	/* Element dimension of impulse value data INT */
int	 esize_flag;	/* Element dimension of impulse value data FLAG */

/*
 *  Number of impulses generated along the element dimension (optional integer)
 */
int	 enum_int; 	/* Number of impulses generated along the element dimension INT */
int	 enum_flag;	/* Number of impulses generated along the element dimension FLAG */

/*
 *  Spacing between two impulses along the width dimension (optional integer)
 */
int	 wsp_int; 	/* Spacing between two impulses along the width dimension INT */
int	 wsp_flag;	/* Spacing between two impulses along the width dimension FLAG */

/*
 *  Offset of first impulse along width dimension (optional integer)
 */
int	 woff_int; 	/* Offset of first impulse along width dimension INT */
int	 woff_flag;	/* Offset of first impulse along width dimension FLAG */

/*
 *  Spacing between two impulses along the height dimension (optional integer)
 */
int	 hsp_int; 	/* Spacing between two impulses along the height dimension INT */
int	 hsp_flag;	/* Spacing between two impulses along the height dimension FLAG */

/*
 *  Offset of first impulse along height dimension (optional integer)
 */
int	 hoff_int; 	/* Offset of first impulse along height dimension INT */
int	 hoff_flag;	/* Offset of first impulse along height dimension FLAG */

/*
 *  Spacing between two impulses along the depth dimension (optional integer)
 */
int	 dsp_int; 	/* Spacing between two impulses along the depth dimension INT */
int	 dsp_flag;	/* Spacing between two impulses along the depth dimension FLAG */

/*
 *  Offset of first impulse along depth dimension (optional integer)
 */
int	 doff_int; 	/* Offset of first impulse along depth dimension INT */
int	 doff_flag;	/* Offset of first impulse along depth dimension FLAG */

/*
 *  Spacing between two impulses along the time dimension (optional integer)
 */
int	 tsp_int; 	/* Spacing between two impulses along the time dimension INT */
int	 tsp_flag;	/* Spacing between two impulses along the time dimension FLAG */

/*
 *  Offset of first impulse along time dimension (optional integer)
 */
int	 toff_int; 	/* Offset of first impulse along time dimension INT */
int	 toff_flag;	/* Offset of first impulse along time dimension FLAG */

/*
 *  Spacing between two impulses along the element dimension (optional integer)
 */
int	 esp_int; 	/* Spacing between two impulses along the element dimension INT */
int	 esp_flag;	/* Spacing between two impulses along the element dimension FLAG */

/*
 *  Offset of the first impulse along the element dimension (optional integer)
 */
int	 eoff_int; 	/* Offset of the first impulse along the element dimension INT */
int	 eoff_flag;	/* Offset of the first impulse along the element dimension FLAG */

/*
 *  Real value assigned to the generated impulse (optional double)
 */
double	 fgreal_double;	/* Real value assigned to the generated impulse DOUBLE */
int	 fgreal_flag;   	/* Real value assigned to the generated impulse FLAG */

/*
 *  Real value assigned to background value data (optional double)
 */
double	 bgreal_double;	/* Real value assigned to background value data DOUBLE */
int	 bgreal_flag;   	/* Real value assigned to background value data FLAG */

/*
 *  Imaginary value of generated impulse  (optional double)
 */
double	 fgimag_double;	/* Imaginary value of generated impulse  DOUBLE */
int	 fgimag_flag;   	/* Imaginary value of generated impulse  FLAG */

/*
 *  Imaginary value assigned to background (optional double)
 */
double	 bgimag_double;	/* Imaginary value assigned to background DOUBLE */
int	 bgimag_flag;   	/* Imaginary value assigned to background FLAG */

/*
 *  Data type of impulse value data (Optional list)
 */
int	 type_list;	/* Data type of impulse value data LIST INDEX */
char	 *type_label;	/* Data type of impulse value data LIST LABEL */
int	 type_flag;	/* Data type of impulse value data FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kimpulse_get_args PROTO((kform *));
void kimpulse_usage_additions PROTO((void));
void kimpulse_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
