 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "khistops.h"
/*-----------------------------------------------------------
| 
|  Routine Name: khistops_get_args
| 
|       Purpose: Gets command line args for khistops
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khistops
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void khistops_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for khistops is out of sync with arguments specified in khistops's *.pane file; please rerun ghostwriter on khistops.";


	/*
	 * allocate the khistops structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "invert",
			  &(clui_info->invert_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "equalize",
			  &(clui_info->equalize_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "stretch",
			  &(clui_info->stretch_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "whole",
			  &(clui_info->whole_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "w",
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "h",
			  &(clui_info->h_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "d",
			  &(clui_info->d_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "t",
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "e",
			  &(clui_info->e_flag))))
	{
	    kerror(NULL, "khistops_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



