 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgenloc
   >>>> 
   >>>>    Written By: Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgenloc_h_
#define _kgenloc_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kgenloc/uis/kgenloc.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  First Input data object (optional infile)
 */
char	*i_file;	/* First Input data object FILENAME */
int	 i_flag;	/* First Input data object FLAG */

/*
 *  Explicit Location Begin for X dimension (optional double)
 */
double	 xbegin_double;	/* Explicit Location Begin for X dimension DOUBLE */
int	 xbegin_flag;   	/* Explicit Location Begin for X dimension FLAG */

/*
 *  Explicit Location End for X dimension (optional double)
 */
double	 xend_double;	/* Explicit Location End for X dimension DOUBLE */
int	 xend_flag;   	/* Explicit Location End for X dimension FLAG */

/*
 *  Explicit Location Begin for Y dimension (optional double)
 */
double	 ybegin_double;	/* Explicit Location Begin for Y dimension DOUBLE */
int	 ybegin_flag;   	/* Explicit Location Begin for Y dimension FLAG */

/*
 *  Explicit Location End for Y dimension (optional double)
 */
double	 yend_double;	/* Explicit Location End for Y dimension DOUBLE */
int	 yend_flag;   	/* Explicit Location End for Y dimension FLAG */

/*
 *  Explicit Location Begin for Z dimension (optional double)
 */
double	 zbegin_double;	/* Explicit Location Begin for Z dimension DOUBLE */
int	 zbegin_flag;   	/* Explicit Location Begin for Z dimension FLAG */

/*
 *  Explicit Location End for Z dimension (optional double)
 */
double	 zend_double;	/* Explicit Location End for Z dimension DOUBLE */
int	 zend_flag;   	/* Explicit Location End for Z dimension FLAG */

/*
 * Grid Type to use when creating Location Data (Optional flag toggle)
 *	1 (create uniform location data)
 *	2 (create rectilinear location data)
 *	3 (create curvilinear location data),
 */
int	 grid_toggle;		/* Grid Type to use when creating Location Data FLAG TOGGLE */
int	 grid_flag;		/* Grid Type to use when creating Location Data FLAG */

/*
 *  Width of location data (optional integer)
 */
int	 wsize_int; 	/* Width of location data INT */
int	 wsize_flag;	/* Width of location data FLAG */

/*
 *  Height of location data (optional integer)
 */
int	 hsize_int; 	/* Height of location data INT */
int	 hsize_flag;	/* Height of location data FLAG */

/*
 *  Depth of location data (optional integer)
 */
int	 dsize_int; 	/* Depth of location data INT */
int	 dsize_flag;	/* Depth of location data FLAG */

/*
 *  Data type of location data (Optional list)
 */
int	 type_list;	/* Data type of location data LIST INDEX */
char	 *type_label;	/* Data type of location data LIST LABEL */
int	 type_flag;	/* Data type of location data FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgenloc_get_args PROTO((kform *));
void kgenloc_usage_additions PROTO((void));
void kgenloc_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
