 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kfft.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kfft_get_args
| 
|       Purpose: Gets command line args for kfft
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kfft
|          Date: Apr 14, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kfft_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kfft is out of sync with arguments specified in kfft's *.pane file; please rerun ghostwriter on kfft.";

	char  *value_string;


	/*
	 * allocate the kfft structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "dir",
			  &(clui_info->dir_logic),
			  &(clui_info->dir_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "center",
			  &(clui_info->center_logic),
			  &(clui_info->center_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "scale", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->scale_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->scale_toggle = atoi(value_string);

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_cycle),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "w",
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "h",
			  &(clui_info->h_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "d",
			  &(clui_info->d_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "t",
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "e",
			  &(clui_info->e_flag))))
	{
	    kerror(NULL, "kfft_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



