 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kfft
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kfft.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Fast Fourier Transform (Forward and Inverse)
|
|       Purpose: main program for kfft
|
|         Input:
|		char *clui_info->i_file; {complex input object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {complex output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    int clui_info->w_flag; {TRUE if -w specified}
|
|		    int clui_info->h_flag; {TRUE if -h specified}
|
|		    int clui_info->d_flag; {TRUE if -d specified}
|
|		    int clui_info->t_flag; {TRUE if -t specified}
|
|		    int clui_info->e_flag; {TRUE if -e specified}
|
|		int clui_info->dir_logic; {FFT direction (0 is forward, 1 is inverse)}
|		int clui_info->dir_flag; {TRUE if -dir specified}
|
|		int clui_info->center_logic; {select to center (1) or not to center (0) the transform}
|		int clui_info->center_flag; {TRUE if -center specified}
|
|		int clui_info->scale_toggle; {scale FFT by 1, 1/N or 1/sqrt(N)}
|		int clui_info->scale_flag; {TRUE if -scale specified}
|
|		int   clui_info->type_cycle; {Output object data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson, Ashish Malhotra
|          Date: Apr 14, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj=NULL ;
        int     direction=0;
        kobject out_obj=NULL;
	int	dcomplex_flag=FALSE;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kfft_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kfft",
		kfft_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kfft_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) == NULL)
        {
           kerror("kfft","main","Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("kfft","main","Cannot open output object.");
           kpds_close_object(in_obj);
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->dir_flag) direction = clui_info->dir_logic;
        
        if (!kpds_copy_object_attr(in_obj,out_obj))
        {
           kerror("kfft","main",
		  "Cannot copy attributes from input object to output object.");
           kexit(KEXIT_FAILURE);
        }

	if (clui_info->type_cycle == 13)   dcomplex_flag = 1;
/* -main_before_lib_call_end */

/* -main_library_call */
	if ( !lkfft(in_obj,
                    clui_info->center_logic,
                    clui_info->w_flag,
                    clui_info->h_flag,
                    clui_info->d_flag,
                    clui_info->t_flag,
                    clui_info->e_flag,
                    clui_info->scale_toggle,
                    direction,
                    dcomplex_flag,
                    out_obj) )
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kfft", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj,out_obj))
        {
           kerror("kfft","main",
		  "Cannot copy remaining data from input object to output.");
           kexit(KEXIT_FAILURE);
        }

        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kfft_usage_additions
| 
|       Purpose: Prints usage additions in kfft_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kfft
|          Date: Apr 14, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kfft_usage_additions(void)
{
	kfprintf(kstderr, "\tFast Fourier Transform (Forward and Inverse)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kfft_free_args
| 
|       Purpose: Frees CLUI struct allocated in kfft_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kfft
|          Date: Apr 14, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kfft_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
