 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kextract.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kextract_get_args
| 
|       Purpose: Gets command line args for kextract
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kextract
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kextract_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kextract is out of sync with arguments specified in kextract's *.pane file; please rerun ghostwriter on kextract.";


	/*
	 * allocate the kextract structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "woff",
			  &(clui_info->woff_int),
			  &(clui_info->woff_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hoff",
			  &(clui_info->hoff_int),
			  &(clui_info->hoff_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "doff",
			  &(clui_info->doff_int),
			  &(clui_info->doff_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "toff",
			  &(clui_info->toff_int),
			  &(clui_info->toff_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "eoff",
			  &(clui_info->eoff_int),
			  &(clui_info->eoff_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "subpos",
			  &(clui_info->subpos_logic),
			  &(clui_info->subpos_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kextract_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



