 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcptoval
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcptoval.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Copy One Segment Into Value Segment of Output
|
|       Purpose: main program for kcptoval
|
|         Input:
|		char *clui_info->i_file; {input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->loc_flag; {TRUE if -loc specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    char *clui_info->segment_string; {Perform operation on user specified segment}
|		    int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas & Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject source_object=NULL;
        kobject destination_object=NULL;
        char *segment_name=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcptoval_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcptoval",
		kcptoval_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcptoval_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* -- want to use some of the kpds presentation functionality -- */ 
	kpds_init();

        /*
         * Open objects.
         */
        if ((source_object = kdms_open(clui_info->i_file, KOBJ_READ)) == NULL) {
           kerror("kcptoval", "main", "Failed to open input object");
           kexit(KEXIT_FAILURE);
        }
 
        if ( (destination_object=kdms_open(clui_info->o_file,
                                           KOBJ_WRITE)) == NULL) {
           kerror("kcptoval", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
 
        /*
         * Set segment to copy.
         */
        if ( clui_info->segment_string ) {
           segment_name = kstring_copy(clui_info->segment_string, NULL);
        }
        else {
           if (clui_info->val_flag) {
              segment_name = kstring_copy(KDMS_SEGMENT_VALUE, NULL);
           }
           else if (clui_info->mask_flag) {
              segment_name = kstring_copy(KDMS_SEGMENT_MASK, NULL);
           }
           else if (clui_info->map_flag) {
              segment_name = kstring_copy(KDMS_SEGMENT_MAP, NULL);
           }
           else if (clui_info->time_flag) {
              segment_name = kstring_copy(KDMS_SEGMENT_TIME, NULL);
           }
           else if (clui_info->loc_flag) {
              segment_name = kstring_copy(KDMS_SEGMENT_LOCATION, NULL);
           }
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * Copy segment.
         */
        if (!lkcptoval(source_object, segment_name, destination_object))
        {
           kfree(segment_name);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kcptoval", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcptoval_usage_additions
| 
|       Purpose: Prints usage additions in kcptoval_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcptoval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcptoval_usage_additions(void)
{
	kfprintf(kstderr, "\tCopy One Segment Into Value Segment of Output\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcptoval_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcptoval_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcptoval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcptoval_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
