 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcpfromval
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcpfromval.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Copy Value Segment Into One Segment of Output
|
|       Purpose: main program for kcpfromval
|
|         Input:
|		char *clui_info->i_file; {Source input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->loc_flag; {TRUE if -loc specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    char *clui_info->segment_string; {Perform operation on user specified segment}
|		    int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas & Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        char    *segment_name=NULL;
        kobject source_obj=NULL, destination_obj=NULL;
	int     index_order[5] = {KWIDTH, KHEIGHT, KDEPTH, KTIME, KELEMENTS};
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcpfromval_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcpfromval",
		kcpfromval_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcpfromval_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Open objects.
         */
        if ((source_obj = kdms_open(clui_info->i_file, KOBJ_READ)) == NULL) {
           kerror("kcpfromval", "main", "Failed to open input object");
           kexit(KEXIT_FAILURE);
        }
 
        if ( (destination_obj = kdms_open(clui_info->o_file,
                                          KOBJ_WRITE)) == NULL) {
           kerror("kcpfromval", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
 
        /*
         * Set segment to copy.
         */
        if ( clui_info->segment_flag ) {
           segment_name = kstrdup(clui_info->segment_string);
        }
        else {
           if (clui_info->val_flag) 
	   {
              segment_name = kstrdup(KDMS_SEGMENT_VALUE);
           }
           else if (clui_info->mask_flag) 
	   {
              segment_name = kstrdup(KDMS_SEGMENT_MASK);
           }
           else if (clui_info->map_flag) 
	   {
              segment_name = kstrdup(KDMS_SEGMENT_MAP);
           }
           else if (clui_info->time_flag) 
	   {
              segment_name = kstrdup(KDMS_SEGMENT_TIME);
           }
           else if (clui_info->loc_flag) 
	   {
              segment_name = kstrdup(KDMS_SEGMENT_LOCATION);
           }
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * Copy segment.  
	 * Specify a dimensionality of five and a basic index order to 
	 * use for cases when a new segment is being created. 
	 */
        if (!lkcpfromval(source_obj, segment_name, 5,
			 &(index_order[0]), destination_obj))
        {
           kfree(segment_name);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        kfree(segment_name);

        /* add history to the output object */
        if (!kpds_set_attribute(destination_obj, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kcpfromval", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcpfromval_usage_additions
| 
|       Purpose: Prints usage additions in kcpfromval_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcpfromval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcpfromval_usage_additions(void)
{
	kfprintf(kstderr, "\tCopy Value Segment Into One Segment of Output\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcpfromval_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcpfromval_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcpfromval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcpfromval_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
