 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kconvert.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kconvert_get_args
| 
|       Purpose: Gets command line args for kconvert
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kconvert
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kconvert_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kconvert is out of sync with arguments specified in kconvert's *.pane file; please rerun ghostwriter on kconvert.";


	/*
	 * allocate the kconvert structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "scale",
			  &(clui_info->scale_double),
			  &(clui_info->scale_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "roff",
			  &(clui_info->roff_double),
			  &(clui_info->roff_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ioff",
			  &(clui_info->ioff_double),
			  &(clui_info->ioff_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "val",
			  &(clui_info->val_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "map",
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mask",
			  &(clui_info->mask_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "loc",
			  &(clui_info->loc_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "time",
			  &(clui_info->time_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "segment",
			  &(clui_info->segment_string),
			  &(clui_info->segment_flag))))
	{
	    kerror(NULL, "kconvert_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



