 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kcompare
   >>>> 
   >>>>    Written By: Donna Koechner & Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kcompare_h_
#define _kcompare_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kcompare/uis/kcompare.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  first input data object (required infile)
 */
char	*i1_file;	/* first input data object FILENAME */
int	 i1_flag;	/* first input data object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  second input data object (optional infile)
 */
char	*i2_file;	/* second input data object FILENAME */
int	 i2_flag;	/* second input data object FLAG */

/*
 *  constant value (optional double)
 */
double	 real_double;	/* constant value DOUBLE */
int	 real_flag;   	/* constant value FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  Equal: if i1 == (i2 or val), i1 = TRUE (optional flag)
 */
int	 eq_flag;  	/* Equal: if i1 == (i2 or val), i1 = TRUE FLAG */

/*
 *  Not Equal:  if i1 != (i2 or val), i1 = TRUE (optional flag)
 */
int	 ne_flag;  	/* Not Equal:  if i1 != (i2 or val), i1 = TRUE FLAG */

/*
 *  Greater Than:  if i1 >  (i2 or val), i1 = TRUE (optional flag)
 */
int	 gt_flag;  	/* Greater Than:  if i1 >  (i2 or val), i1 = TRUE FLAG */

/*
 *  Greater Than or Equal:  if i1 >= (i2 or val), i1 = TRUE (optional flag)
 */
int	 ge_flag;  	/* Greater Than or Equal:  if i1 >= (i2 or val), i1 = TRUE FLAG */

/*
 *  Less Than:  if i1 <  (i2 or val), i1 = TRUE (optional flag)
 */
int	 lt_flag;  	/* Less Than:  if i1 <  (i2 or val), i1 = TRUE FLAG */

/*
 *  Less Than or Equal:  if i1 <= (i2 or val), i1 = TRUE (optional flag)
 */
int	 le_flag;  	/* Less Than or Equal:  if i1 <= (i2 or val), i1 = TRUE FLAG */

/*-- required ME group end ---*/

/*
 *  Tolerance (optional double)
 */
double	 tol_double;	/* Tolerance DOUBLE */
int	 tol_flag;   	/* Tolerance FLAG */

/*
 *  Value assigned to output if evaluation is TRUE (optional double)
 */
double	 tval_double;	/* Value assigned to output if evaluation is TRUE DOUBLE */
int	 tval_flag;   	/* Value assigned to output if evaluation is TRUE FLAG */

/*
 *  Value assigned to output if evaluation is FALSE (optional double)
 */
double	 fval_double;	/* Value assigned to output if evaluation is FALSE DOUBLE */
int	 fval_flag;   	/* Value assigned to output if evaluation is FALSE FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kcompare_get_args PROTO((kform *));
void kcompare_usage_additions PROTO((void));
void kcompare_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
