 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kcomment.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kcomment_get_args
| 
|       Purpose: Gets command line args for kcomment
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcomment
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcomment_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kcomment is out of sync with arguments specified in kcomment's *.pane file; please rerun ghostwriter on kcomment.";


	/*
	 * allocate the kcomment structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "s",
			  &(clui_info->s_string),
			  &(clui_info->s_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "ed",
			  &(clui_info->ed_logic),
			  &(clui_info->ed_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "re",
			  &(clui_info->re_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "pr",
			  &(clui_info->pr_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ap",
			  &(clui_info->ap_flag))))
	{
	    kerror(NULL, "kcomment_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



