 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kclip.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kclip_get_args
| 
|       Purpose: Gets command line args for kclip
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kclip
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kclip_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kclip is out of sync with arguments specified in kclip's *.pane file; please rerun ghostwriter on kclip.";


	/*
	 * allocate the kclip structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "thresh",
			  &(clui_info->thresh_logic),
			  &(clui_info->thresh_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "fval",
			  &(clui_info->fval_double),
			  &(clui_info->fval_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tval",
			  &(clui_info->tval_double),
			  &(clui_info->tval_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "lc",
			  &(clui_info->lc_double),
			  &(clui_info->lc_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "ilc",
			  &(clui_info->ilc_file),
			  &(clui_info->ilc_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "uc",
			  &(clui_info->uc_double),
			  &(clui_info->uc_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "iuc",
			  &(clui_info->iuc_file),
			  &(clui_info->iuc_flag))))
	{
	    kerror(NULL, "kclip_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



