#!/bin/sh

#
# Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kregister - Regististration Program for Khoros Software
#
#       Purpose: This program allows a user/site to register Khoros
#		 with the Khoral Research, so they can get information
#		 about software updates, Khoros classes, and licensing.
#    Written By: Steven Jorgensen
#          Date: Aug 23, 1994
# Modifications: 
#
#************************************************************

progname=kregister
subject="\"$progname Registration Information\""
email="kregister@khoros.unm.edu"

# This section begins a useful library of routines that are general enough to
# be used in other sh scripts.
# ------------------------------------------------------------------------
# set up some other standard commands.
# eventually we should do something like the below code for echo,
# check for each of them on the path.  Oh for perl!
 
  cp="cp"
  mv="mv -f"
  rm="rm -f"
 awk="awk"
 sed="sed"
grep="grep"
TMPDIR=${TMPDIR:-/tmp}

mclr=""
for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
        [ -x "$dir/clear" ] && mclr="$dir/clear"
done
if [ "$mclr" = "" ]; then
        mclr=echo -c "[H[J"
fi


# clean up if they interrupt the script.
#----------------------------------------------------------
cleanup()
{
	$rm $TMPDIR/$progname*.$$
	echo ""
	echo "Kregister has terminated abnormally, you're registration has"
	echo "not been completed."
	echo ""
	exit 0
}

trap cleanup 2

# build a $echoN variable and $echoEnd combination that will give
# will allow the echon procedure to work well.
FindEchoN()
{
	# build a list of potential echos, starting with sh built-in
	echoEnd=""
	elist="echo"
	for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
	        [ -x "$dir/echo" ] && elist="$elist $dir/echo"
	done
 
	# work through list, see if one of them groks -n
	for echo in $elist; do
	        result=`$echo -n hello`
	        if [ "$result" != "-n hello" ]; then
	                echoN="$echo -n"
	                break
	        fi
	done
	if [ "$echoN" = "" ]; then
	        echoN=echo
		echoEnd="\c"
		result=`$echoN "testing"$echoEnd`
		if [ "$result" != "testing" ]; then
			unset echoEnd
		fi
	fi
}

# echo without without return
echon()
{
	$echoN "$* $echoEnd"
}

# clear screen function
clr()
{
	$mclr
}

# prompt the user, to see if we should go on
YesNoPrompt()
{
	if [ "$#" -eq 0 ]; then
	        echon "Do you wish to continue? (y/n) [y]:"
	else
		echon "$1 (y/n) [y]:"
	fi
        read resp
        if [ "$resp" = "n" -o "$resp" = "N" ]; then
		return 1
        fi
	return 0
}

# prompt the user for a string
StringPrompt()
{
	if [ "$2" = "none" ]; then
		echon "$1 [(no default)]: "
	else
		echon "$1 [$2]: "
	fi
	read strval
	if [ "$strval" = "" -a "$2" != "none" ]; then
		strval=$2
	fi
	if [ "$strval" = "none" ]; then
		strval=""
	fi
}

# prompt the user for a string, and keep bugging them until they give me
# somethin other than NULL
ReqStringPrompt()
{
	val=1
	until [ $val -eq 0 ]; do
		StringPrompt "$1" "$2"
		if [ "$strval" != "" ]; then
			val=0
		else
			echo ""
			echo "You must give a non-empty response to this prompt"
		fi
	done
}

# email the program to send email
FindMailer()
{
	mailer="/usr/ucb/mail"
	if [ -x $mailer ]; then
		return
	fi

	dlist=`echo $PATH | $sed -e 's/:/ /g'`

	for dir in $dlist; do
        	if [ -x "$dir/mailx" ]; then
			mailer="$dir/mailx"
			return
		fi
	done

	for dir in $dlist; do
		if [ -x "$dir/mail" ]; then
			mailer="$dir/mail"
			return
		fi
	done
	mailer="none"
}

# find the date
FindDate()
{
	date_prog="/bin/date"
	if [ -x $date_prog ]; then
		date=`$date_prog`
		return
	fi

	dlist=`echo $PATH | $sed -e 's/:/ /g'`

	date_prog=""
	for dir in $dlist; do
        	if [ -x "$dir/date" ]; then
			date_prog="$dir/date"
			break
		fi
	done
	if [ "$date_prog" = "" ]; then
		date="none"
	else
		date=`$date_prog`
	fi
}

# get printer command
GetPrintCom()
{
	val=1
	printcmd="none"
	until [ $val -eq 0 ]; do
		echo ""
		echo "You picked an option that requires that the information"
		echo "be sent to a printer.  In order to do this, please provide"
		echo "the complete command to print to your printer."
		echo "(i.e. 'lpr -Pprintername' or 'lp -d printername')."
		echo ""
		ReqStringPrompt "Printer Command:" "$printcmd"
		printcmd="$strval"
		echo ""
		YesNoPrompt "Is the printer command: '$printcmd' correct?"
		val=$?
	done
}

# This section begins the routines that are specific to this shell script
# ------------------------------------------------------------------------
# find template files
FindFiles()
{
	if [ "$KHOROS_TOOLBOX" = "" ]; then
		cat <<"		EndError"

	The environment variable KHOROS_TOOLBOX has not been set.
	Please use the 'kconfigure' program to correctly set up
	your environment to use Khoros, and rerun kregister.

		EndError
		cleanup
	fi
	for tbfile in `echo $KHOROS_TOOLBOX | $sed -e 's/:/ /g'`; do
        	[ -f "$tbfile" ] && tblist="$tblist $tbfile"
	done
	for tbfile in $tblist; do
 		topdir=`$grep BOOTSTRAP $tbfile | $awk -F: '{print $2}'`
		if [ "$topdir" != "" ]; then
			break
        	fi
	done

	if [ "$topdir" = "" ]; then
		echo ""
		echo "Cannot find the top directory for the BOOTSTRAP Toolbox"
		echo "in your the file(s) listed in your KHOROS_TOOLBOX"
		echo "variable.  Please set this variable correctly, or"
		echo "use 'kconfigure' to correctly set up your environment"
		cleanup
	fi
# Change this when INSTALLED
	topdir=$topdir/objects/script/kregister/misc
#	topdir=/research/devel/mirage/work/steve/worktb/objects/script/kregister/misc
	if [ ! -d $topdir ]; then
		echo ""
		echo "The directory '$topdir' that"
		echo "was found for kregister's support files is not a"
		echo "directory.  This implies that either the BOOTSTRAP"
		echo "entry in your Toolbox file is incorrect, or kregister"
		echo "is not installed in BOOTSTRAP.  Please fix the problem"
		echo "and rerun 'kregister'."
		cleanup
	fi
	ps_file=$topdir/kregister_fill.ps
	ascii_file=$topdir/kregister_fill.ascii
	email_file=$topdir/kregister_fill.email
	if [ ! \( -r $ps_file -a -r $email_file -a -r $ascii_file \) ]; then
		echo ""
		echo "ERROR:  Unable to read one or all of the template files"
		echo "for the registration program.  This implies that the"
		echo "files are either gone or unreadable."
		cleanup
	fi
}

# get registration information from user
GetInformation()
{
	     val="1"
	    name="none"
	    org1="none"
	    org2="none"
	    add1="none"
	    add2="none"
	    add3="none"
	    add4="none"
	    phon="none"
	     fax="none"
	  uemail="none"
	     num="none"
	 version="none"
	    use1="none"
	    use2="none"
	comment1="none"
	comment2="none"
	comment3="none"

	until [ $val -eq 0 ]; do
		clr
		echo "This program will ask you a series of questions. Default values"
		echo "are shown in []'s.  If no default exists, [(no default)] is shown."
                echo ""
                echo "Note, empty defaults are valid (i.e. []). So, if you want to give"
		echo "an empty response to a prompt that already has a default, type"
		echo "\"none\" at the prompt."
		echo ""
		ReqStringPrompt "Please Enter Your Name" "$name"
		name="$strval"
		echo ""
		echo "Please Enter Your Organization Name (two input lines)"
		StringPrompt "Organization Name (line 1): " "$org1"
		org1="$strval"
		StringPrompt "Organization Name (line 2): " "$org2"
		org2="$strval"
		echo ""
		echo "Please Enter Your Organization Address (four input lines)"
		StringPrompt "Organization Address (line 1): " "$add1"
		add1="$strval"
		StringPrompt "Organization Address (line 2): " "$add2"
		add2="$strval"
		StringPrompt "Organization Address (line 3): " "$add3"
		add3="$strval"
		StringPrompt "Organization Address (line 4): " "$add4"
		add4="$strval"
		echo ""
		StringPrompt "Please Enter Your Phone Number: " "$phon"
		phon="$strval"
		echo ""
		StringPrompt "Please Enter Your FAX Number: " "$fax"
		fax="$strval"
		echo ""
		echo "Please Enter Your"
		StringPrompt "Internet E-Mail address: " "$uemail"
		uemail="$strval"
		echo ""
		echo "Please Enter the Approximate"
		StringPrompt "Number of Users at your Site: " $num
		num="$strval"
		echo ""
		echo "Please Enter a brief description of how you are using Khoros (two input lines)"
		StringPrompt "Use (line 1): " "$use1"
		use1="$strval"
		StringPrompt "Use (line 2): " "$use2"
		use2="$strval"
		echo ""
		echo "Please Enter Any Comments (three input lines)"
		StringPrompt "Comments (line 1): " "$comment1"
		comment1="$strval"
		StringPrompt "Comments (line 2): " "$comment2"
		comment2="$strval"
		StringPrompt "Comments (line 3): " "$comment3"
		comment3="$strval"
		clr
		echo "Please verify the information entered."
		echo ""
		echo "        Name: $name"
		echo "Organization: $org1"
		echo "              $org2"
		echo "     Address: $add1"
		echo "              $add2"
		echo "              $add3"
		echo "              $add4"
		echo ""
		echo "       Phone: $phon"
		echo "         Fax: $fax"
		echo "      E-Mail: $uemail"
		echo ""
		echo "  # of Users: $num"
		echo ""
		echo "         Use: $use1"
		echo "              $use2"
		echo ""
		echo "    Comments: $comment1"
		echo "              $comment2"
		echo "              $comment3"
		echo ""
		YesNoPrompt "Is the information you entered correct?"
		val=$?
	done
	FindDate
	echo ""
	YesNoPrompt "Would you like additional information on Khoros training courses?"
	if [ "$?" -eq 1 ]; then
		training="NO"
	else
		training="YES"
	fi
	echo ""
	YesNoPrompt "Would you like additional information on Khoros licensing?"
	if [ "$?" -eq 1 ]; then
		licensing="NO"
	else
		licensing="YES"
	fi
	echo ""
	YesNoPrompt "Would you like additional information on the Khoros Consortium?"
	if [ "$?" -eq 1 ]; then
		consort="NO"
	else
		consort="YES"
	fi
}

# substitute answers into ps file
SubPs()
{
	echo "s/^(Name #1)/($name)/g" > $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Company Name #1)/($org1)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Company Name #2)/($org2)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Address #1)/($add1)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Address #2)/($add2)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Address #3)/($add3)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Address #4)/($add4)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Phone #1)/($phon)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Fax #1)/($fax)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(E-Mail #1)/($uemail)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Users #1)/($num)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Date #1)/($date)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Use #1)/($use1)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Use #2)/($use2)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Comments #1)/($comment1)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Comments #2)/($comment2)/g" >> $TMPDIR/kregister.sub_ps.$$
	echo "s/^(Comments #3)/($comment3)/g" >> $TMPDIR/kregister.sub_ps.$$
	if [ "$training" = "YES" ]; then
		echo "s/^(q) 72 156/(3) 72 156/g" >> $TMPDIR/kregister.sub_ps.$$
	fi
	if [ "$licensing" = "YES" ]; then
		echo "s/^(q) 72 130/(3) 72 130/g" >> $TMPDIR/kregister.sub_ps.$$
	fi
	if [ "$consort" = "YES" ]; then
		echo "s/^(q) 72 104/(3) 72 104/g" >> $TMPDIR/kregister.sub_ps.$$
	fi
	$sed -f $TMPDIR/kregister.sub_ps.$$ $ps_file > $TMPDIR/kregister.ps.$$
}

# substitute answers into a text file for email
SubTxt()
{
	echo "s/User Name #1/$name/g" > $TMPDIR/kregister.sub_txt.$$
	echo "s/Company Name #1/$org1/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Company Name #2/$org2/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Address #1/$add1/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Address #2/$add2/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Address #3/$add3/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Address #4/$add4/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Phone #1/$phon/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Fax #1/$fax/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/E-Mail #1/$uemail/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Users #1/$num/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Date #1/$date/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Use #1/$use1/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Use #2/$use2/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Comments #1/$comment1/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Comments #2/$comment2/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Comments #3/$comment3/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Q1/$training/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Q2/$licensing/g" >> $TMPDIR/kregister.sub_txt.$$
	echo "s/Q3/$consort/g" >> $TMPDIR/kregister.sub_txt.$$
	$sed -f $TMPDIR/kregister.sub_txt.$$ $ascii_file > $TMPDIR/kregister.ascii.$$
	$sed -f $TMPDIR/kregister.sub_txt.$$ $email_file > $TMPDIR/kregister.email.$$
}

# email the registration
RegEmail()
{
	FindMailer
	if [ "$mailer" != "none" ]; then
		$mailer $email <$TMPDIR/kregister.email.$$ >/dev/null 2>&1
	else
		$cp $TMPDIR/kregister.email.$$ ./kregister_email
		echo ""
		echo "I cannot find a mailer program that I understand, please"
		echo "send the file 'kregister_email' in the current directory"
		echo "to kregister@khoros.unm.edu in the exact form it is"
		echo "currently in"
	fi
}

# print the postscript registration
RegPrintPS()
{
	GetPrintCom
	echo ""
	echo "Printing the Postscript Registration Form..."
	$printcmd $TMPDIR/kregister.ps.$$
}

# print the ascii registration
RegPrintAscii()
{
	GetPrintCom
	echo ""
	echo "Printing the ASCII Registration Form..."
	$printcmd $TMPDIR/kregister.ascii.$$
}

# Give the users an Option for their registration method
PickRegMethod()
{
	nummethods=5
	val=0
	until [ $val -gt 0 -a $val -le $nummethods ]; do
		clr
		echo "Submit registration via:"
		echo ""
		echo "1. Email to kregister@khoros.unm.edu"
		echo "2. Printed Postscript Registration Form to be Mailed or FAXed to KRI"
		echo "3. Printed ASCII Registration Form to be Mailed or FAXed to KRI"
		echo "4. Submit via Email and Print a Postscript copy of the information"
		echo "5. Submit via Email and Print a ASCII copy of the information"
		echo ""
		echon "Enter the method to use for submittion: [1-$nummethods] "
		read val

		if [ "$val" = "" ]; then
			val=0
		fi

		if [ "$val" -le 0 -o "$val" -gt "$nummethods" ]; then
			echo ""
			echo "Invalid selection.  Only values between 1 and $nummethods are valid"
			echo "Please re-enter."
			sleep 2
		fi
	done
	method=$val

	case $method in
		1 )	echo "You picked the E-Mail registration method"
			RegEmail;;
		2 )	echo "You picked the Postscript registration form method"
			RegPrintPS;;
		3 )	echo "You picked the ASCII registration form method"
			RegPrintAscii;;
		4 )	echo "You picked the E-Mail registration with a"
			echo "Printed Postscript record"
			RegEmail
			RegPrintPS;;
		5 )	echo "You picked the E-Mail registration with a"
			echo "Print ASCII record"
			RegEmail
			RegPrintAscii;;
	esac
}

# print introduction and paragraph explaining the program, and ask if
# they wish to continue
PrintIntroduction()
{
	clr
	cat <<"	EndIntro"

                     KHOROS USER REGISTRATION

        THANK YOU for using Khoros and taking the time to complete this
        this registration process. It should take about five minutes. 
        The completed registration form can be emailed, faxed or mailed 
        back to Khoral Research, Inc.

        The information you provide will help enable us to continue
        to develop and distribute quality products. In addition, this
        information gives us some statistics on the Khoros user base.

        Also, you will have the option to request additional information 
        on Khoros, licensing and training.

	If you have any immeadiate questions, please contact: 
             Khoral Research, Inc.
             6001 Indian School Rd, NE, Suite 200
             Albuquerque, NM 87110
             (505) 837-6500
             Fax: (505) 881-3842
             khoros-request@khoros.unm.edu

	EndIntro
	YesNoPrompt "	Continue with Registration?"
	if [ "$?" -eq 1 ]; then
		echo ""
		echo ""
		echo "If you have not already registered your version of Khoros,"
		echo "we hope you will register at a later date."
		exit 0
	fi
}

# This section begins the main program part of the sh script
# ------------------------------------------------------------------------

FindEchoN
FindFiles
PrintIntroduction
GetInformation
SubPs
SubTxt
PickRegMethod
echo ""
echo "Thank you for Registering your version of Khoros"
$rm $TMPDIR/kregister.*.$$
exit 0

