eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kgenglossary - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'generate glossary for manual';
@clui_args  = (
        '[verbose]', '',      'display verbose information as program runs'
);

# initialize Khoros perl lib
&khoros'initialize("BOOTSTRAP",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

opendir(MANDIR, "./..") || die "Can't read parent directory: $!\n";
@directories = grep(/^[^.]/, readdir(MANDIR));
closedir(MANDIR);

foreach $dir (@directories)
{
   next unless -d "../$dir" && -f "../$dir/glossary.raw";

   open(RAWFILE, "< ../$dir/glossary.raw") || do
   {
      warn "kgenglossary: Could not read glossary.raw for chapter $dir: $!\n";
      next;
   };

   (print "kgenglossary:"),$ok=1 unless $ok;
   print " $dir";
   while (<RAWFILE>)
   {
      chop;
      ($word,$definition) = split(/:/);
      $glossary{$word} = $definition;
   }
}
close RAWFILE;
print "\n" if $ok;

open(ROFF, "> glossary.roff") || die "Can't write glossary.roff: $!\n";
foreach $word (sort keys %glossary)
{
   $section = substr($word, 0, 1);
   $section = "\U$section";
   if ($section ne $cursect)
   {
      print ROFF ".LB \"$section\"\n";
      $cursect = $section;
   }
   print ROFF ".G< \"$word\" \"",$glossary{$word},"\"\n";
}
close(ROFF);
