/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros Hash Utility
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>   Public:
   >>>>			khash()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/************************************************************
*
*  Routine Name: khash - polynomial conversion 
*
*       Purpose: polynomial conversion ignoring overflows
*		 [this seems to work remarkably well, in fact better
*		 then the ndbm hash function. Replace at your own risk]
*
*		 ! 	use:  65599	nice.
*		 ! 	      65587   even better. 
*
*         Input: data - the data in which to create the has for
*		 length - the length of the hash to be used.  If -1,
*			  then the length is computed using kstrlen().
*        Output:
*       Returns: returns the associated hash for the given data.
*
*  Restrictions:
*    Written By: Ozan S. Yigit (oz@nexus.yorku.ca)
*          Date: 1991 
*      Verified:
*  Side Effects:
* Modifications: Integrated into Khoros 2.0 (MY) 4/93
*   Declaration: long khash(
*		!   char *data,
*		!   int  length)
*
*************************************************************/

long khash(
   register char *data,
   register int  length)
{
	register unsigned long n = 0;


#define HASHC	n = *data++ + 65599 * n
	if (length <= -1)
	   length = kstrlen(data);

	switch (length % 8)
	{
	   case 7: HASHC;
	   case 6: HASHC;
	   case 5: HASHC;
	   case 4: HASHC;
	   case 3: HASHC;
	   case 2: HASHC;
	   case 1: HASHC;
	}

	length >>= 3;
	while (length-- > 0)
	{
	    HASHC; HASHC; HASHC; HASHC;
	    HASHC; HASHC; HASHC; HASHC;
	}
	return n;
}
