/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for kforms  library
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: March 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kforms_internals_h_
#define _kforms_internals_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <bootstrap.h>
#include "attributes.h"

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#define KUIS_MAX_DB_SIZE 512

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

extern kform_struct *kformstruct_hdr;
extern kform_struct *kformstruct_tail;
extern int          kvf_context;

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *   Utilities for checking the UIS (check.c)
 */
int kvf_check_for_subform_buttons PROTO((char **, int));
int kvf_check_for_guide_buttons   PROTO((char **, int));
int kvf_check_me_member_default   PROTO((int *, int, int, int *, int *, char **));
int kvf_check_mi_member_default   PROTO((int *, int, int, int *, int *, char **));
int kvf_check_me_group_default    PROTO((int *, int, int *, int *, char **));
int kvf_check_int                 PROTO((int, int, int, char *, char *));
int kvf_check_float               PROTO((float, float, float, char *, char *));
int kvf_check_double              PROTO((double, double, double, char *, char *));
int kvf_check_bounds              PROTO((double, double, double));

/*
 *   Cleanup Routines (cleanup.c)
 */
void kvf_free_line_info         PROTO((Line_Info *));
void kvf_free_line_info_strings PROTO((Line_Info *));
void kvf_destroy_subform        PROTO((ksubform *));
void kvf_destroy_control        PROTO((kcontrol *));
void kvf_destroy_guide          PROTO((kguide *));
void kvf_destroy_sel_list       PROTO((kselection *));
void kvf_destroy_selection      PROTO((kselection *));
void kvf_delete_kformstructs    PROTO((kform *));

/*
 *   Copy Form Routines (copy.c)
 *   (see kformsP.h)
 */

/*
 *   Utilities for Form Tree Creation (create_util.c)
 */
void kvf_link_subform   PROTO((kcontrol *, ksubform *, ksubform **));
void kvf_link_guide     PROTO((kcontrol *, kguide *, kguide **));
void kvf_link_sel       PROTO((kcontrol *, kselection *, kselection **));
void kvf_link_selection PROTO((kcontrol *, kselection *));
void kvf_link_member    PROTO((kselection *, kselection *, kselection **));
void kvf_link_toggle    PROTO((kselection *, kselection *, kselection **));
void kvf_link_submenu   PROTO((kselection *, kform_struct *, kform_struct **));

char *kvf_find_matching_M_line PROTO((char **, int, int *, int *,
                                      char **, int *));
char *kvf_find_matching_P_line PROTO((char **, int, int *, int *,
                                      char **, int *));

int   kvf_set_subform_values   PROTO((kcontrol *, ksubform *, char *,
                                      int, kform *, kselection *, int,
                                      int *, int *, char **));
int   kvf_set_guide_values     PROTO((kcontrol *, kguide *, char *,
                                      kform *, ksubform *,
                                      kselection *, int, int *, int *,
                                      char **));
int  kvf_set_selection_values PROTO((kselection *, char *, int, kform *,
                                      ksubform *, kguide *, kcontrol *,
                                      kselection *, char *, char *));
int kvf_error_on_submenu       PROTO((int, int, int *, int *, char **));
int kvf_error_with_filetype    PROTO((int, int, int, int *, int *, char **));

ksubform   *kvf_find_subform   PROTO((ksubform *,  int));
kguide     *kvf_find_guide     PROTO((kguide *,     int));
kselection *kvf_find_selection PROTO((kselection *, int));

/*
 * Utilities for reading UIS files
 */
char **kvf_copy_database PROTO((char **, int **, int **, int *));

/*
 *   Error Utilities (error.c)
 */
int kvf_error_on_submenu    PROTO((int, int, int *, int *, char **));
int kvf_error_with_filetype PROTO((int, int, int, int *, int *, char **));

/*
 *   ME/MI/Loose Group Utilities (group.c)
 */
void kvf_call_do_group       PROTO((kselection *, int));
void kvf_set_group_selection PROTO((kselection *, int));



/*
 *  UIS Parsing Routines (parser.c)
 *  (see kformsP.h)
 */
int kvf_realloc_val_labelnum      PROTO((Line_Info *, int));

/*
 *   Utilities for printing form tree (print.c)
 */
void kvf_print_names PROTO((kform *));

int  kvf_print_panefile    PROTO((kcontrol *, int));
int  kvf_print_subformfile PROTO((ksubform *, int));

char *kvf_retrieve_subform_filename PROTO((ksubform *));
char *kvf_retrieve_pane_filename    PROTO((kcontrol *));


/*
 *   General Utilities (utilities.c)
 */
char *kvf_get_comments             PROTO((char **, int *));
void  kvf_initialize               PROTO((void));
void  kvf_parsing_error_mesg       PROTO((int, int *, int *, char **));
void  kvf_allocation_error_mesg    PROTO((void));
int   kvf_set_int_from_literal     PROTO((kselection *, char *));
int   kvf_set_float_from_literal   PROTO((kselection *, char *));
int   kvf_set_double_from_literal  PROTO((kselection *, char *));
int   kvf_set_file_from_literal    PROTO((kselection *, char *));


/*
 *   Routine to deal with kform_struct's (kformstruct.c)
 */
kform_struct *kvf_create_struct PROTO((kaddr, int, int));


#endif /* _kforms_internals_h_ */
/* Do not add after this line */
