/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Holds predefined static strings for
   >>>>                use with code generation utility routines
   >>>>                in print_util.c
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Jul 7, 1992
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcodegen_strings_h_
#define _kcodegen_strings_h_

/*
 *    These cryptic lines are for *.c file headers
 */

static char 
     *kfilehdr_begin =
"/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<",
     *kfilehdr_priv =
"   >>>>  Private: ",
     *kfilehdr_stat =
"   >>>>   Static: ",
     *kfilehdr_pub =
"   >>>>   Public: ",          
     *kfilehdr_sep =
"   >>>> ",
     *kfilehdr_end =
"   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */";

/*
 *    These cryptic lines are for *.h file headers
 */
static char
     *kfilehdr_purp =
"   >>>>       Purpose: ",
     *kfilehdr_auth =
"   >>>>    Written By: ",
     *kfilehdr_date =
"   >>>>          Date: ",
     *kfilehdr_mods =
"   >>>> Modifications: ";

/*
 *    These cryptic lines are for standardized comments in *.h files 
 */
static char
     *kinclfile_comm_begin = 
"        /*-------------------------------------*",
     *kinclfile_comm_include =
"         |       #includes",
     *kinclfile_comm_defines =
"         |       #defines",
     *kinclfile_comm_typedefs =
"         |       typedefs",
     *kinclfile_comm_globals =
"         |       global variable declarations",
     *kinclfile_comm_macros =
"         |       macros",
     *kinclfile_comm_defs =
"         |       routine definitions",
     *kinclfile_comm_end =
"        ---------------------------------------*/";

/*
 *      These cryptic lines are for includes
 */

char *includevin= "#include \"khoros.h\"\n";
char *includexvin= "#include \"xvinclude.h\"\n";

/*
 *    These cryptic lines are headers of public routines
 */

static char 
     *kpubsrc_hdr_begin =
"/****************************************************************",
     *kpubsrc_hdr_name =
"*  Routine Name: ",
     *kpubsrc_hdr_purp =
"*       Purpose: ",
     *kpubsrc_hdr_in =
"*         Input: ",
     *kpubsrc_hdr_out =
"*        Output: ",
     *kpubsrc_hdr_ret =
"*       Returns: ",
     *kpubsrc_hdr_rest =
"*  Restrictions: ",
     *kpubsrc_hdr_auth =
"*    Written By: ",
     *kpubsrc_hdr_date =
"*          Date: ",
     *kpubsrc_hdr_ver  =
"*      Verified: ",
     *kpubsrc_hdr_side =
"*  Side Effects: ",
     *kpubsrc_hdr_mods =
"* Modifications: ",
     *kpubsrc_hdr_sep =
"* ",
     *kpubsrc_hdr_end =
"****************************************************************/";

/*
 *    These cryptic lines are headers of shell script routines
 */

static char
     *kshsrc_hdr_begin =
"#***************************************************************",
     *kshsrc_hdr_name =
"#  Routine Name: ",
     *kshsrc_hdr_purp =
"#       Purpose: ",
     *kshsrc_hdr_rest =
"*  Restrictions: ",
     *kshsrc_hdr_auth =
"#    Written By: ",
     *kshsrc_hdr_date =
"#          Date: ",
     *kshsrc_hdr_mods =
"* Modifications: ",
     *kshsrc_hdr_sep =
"# ",
     *kshsrc_hdr_end =
"#***************************************************************";

/*
 *    These cryptic lines are headers of private routines
 */
static char 
     *kprivsrc_hdr_begin =
"/*-----------------------------------------------------------",
     *kprivsrc_hdr_name =
"|  Routine Name: ",
     *kprivsrc_hdr_purp =
"|       Purpose: ",
     *kprivsrc_hdr_in =
"|         Input: ",
     *kprivsrc_hdr_out =
"|        Output: ",
     *kprivsrc_hdr_auth =
"|    Written By: ",
     *kprivsrc_hdr_date =
"|          Date: ",
     *kprivsrc_hdr_mods =
"| Modifications: ",
     *kprivsrc_hdr_sep =
"| ",
     *kprivsrc_hdr_end =
"------------------------------------------------------------*/";



/*
 *    These cryptic lines are for required global variables
 */

char *kglobal1 = "char\t**av,\t\t/* argv and argc used by gparams */\n\t*program;\t /* a pointer to the program name argv[0] */\n";
char *kglobal2 = "int\tac;\n";


#endif /* _kcodegen_strings_h_ */
/* Don't add anything after the endif */
