/*
 * Khoros: $Id$
 */
 
/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Internal Configuration Management Services Include
   >>>>
   >>>>    Written By: Tom Sauer, Steve Jorgensen
   >>>>
   >>>>          Date: Jul 13, 1992 16:45
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_toolboxP_h_
#define _kcms_toolboxP_h_

	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <bootstrap.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define CM_VERSION       "1"
#define TOOLBOX_DB_PATH  "repos/db/cms"

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


/*
 *   Definition for program and library objects, used by the internal 
 *   CMS manipulation routines.  This structure should not be manipulated by the
 *   application programmer but used as the "id" parameter for the public
 *   CMSL routines.
 */
struct _kobject
{
   int	         type;
   int	         attribute_cnt;
   AttrTbl       *attributes;
   int	         (*add_sub_obj) PROTO((kobject, kobject));
   int	         (*del_sub_obj) PROTO((kobject, kobject));
   int	         (*mod_sub_obj) PROTO((kobject, kobject));
   kobject       parent;

   klist         *callbacks;

   /*--------------------------------------------------------
   |	general toolbox info
   +-------------------------------------------------------*/

   kstring        name;
   kstring        path;
   kstring        dbpath;
   kstring        title;

   kstring        short_copyright;
   kbool          default_short_copyright;

   kstring        long_copyright;
   kbool          default_long_copyright;

   kobject        info_file;
   kobject        config_file;
   kobject        include_file;
   kobject        alias_file;
   kobject        todo_file;
   kobject        changelog_file;

   /*-- list of keywords ----------------------------------------------*/
   klist         *keywords;

   /*-- sub object variables ------------------------------------------*/
   klist         *sw_objects;
   klist         *misc_files;

   /*-- list of app-defaults files ------------------------------------*/
   klist         *app_defaults;


   /*-- ci file information -------------------------------------------*/
   char	        **icon_names;
   char	        **panes;
   char	        **workspaces;
   char	        **cats;
   char	        **subcats;
   char	        **progs;
   int	         *otypes;
   char	        **short_descriptions;
   int	         *incantata;
   int	          ci_size;
   int	          ci_set;

   kstring        poc_email;
   kstring        poc_name;

   /*-- miscellaneous flags and state information ---------------------*/
   unsigned long  flags;

   int	          update;			/*-- update db on close? --*/
   int	          status;

   kstring        version;

   kcms_times     times;
};

typedef struct _kobject *tbdebug;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/



	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

AttrTbl *kcms_tb_attr_table	PROTO((void));
int	 kcms_tb_sync		PROTO((kobject));
kobject	 kcms_tb_open		PROTO((char *));
int	 kcms_tb_close		PROTO((kobject));

#endif /* _kcms_toolboxP_h_ */
/* Don't add after this point */
