/*
 * Khoros: $Id$
 */
 
/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Internal Configuration Management Services Include
   >>>>
   >>>>    Written By: Tom Sauer, Steve Jorgensen, Neil Bowers
   >>>>
   >>>>          Date: Jul 13, 1992 16:45
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_internals_h_
#define _kcms_internals_h_

	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <bootstrap.h>
#include <kcms/private.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define KCMS			"kcms"


/*-----------------------------------------------------------------------
|	The KCMS_COPYRIGHT_TOOLBOX symbol should be defined as a string
|	containing the name of the toolbox which contains the default
|	copyright strings.  When getting the copyright attribute for a
|	toolbox, if the attribute is not defined, then the value from
|	this default toolbox will be returned.
-----------------------------------------------------------------------*/
#define KCMS_COPYRIGHT_TOOLBOX		"boot" "strap"

/*-- default version strings ------------------------------------------*/
#define KCMS_DEFAULT_TB_VERSION         "2.0.2"
#define KCMS_DEFAULT_SW_VERSION         "2.0.2.0"

/*-- default version strings ------------------------------------------*/
#define KCMS_DATE_FORMAT		"%d %B %Y %H:%M:%S"


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef kbool (*attribute_handler) PROTO((kobject, int, kva_list *));

typedef struct attr_tbl
{
	int			int_token;
	attribute_handler	get_attr;
	attribute_handler	set_attr;
} AttrTbl;

/*-----------------------------------------------------------------------
|	This is the structure used to hold details of an attribute
|	callback.  An object can have a linked list of this structure.
-----------------------------------------------------------------------*/
typedef struct _CallbackInfo
{
   int        attribute;
   void     (*callback) PROTO((kobject, int, void *));
   void      *client_data;
} CallbackInfo;

/*-----------------------------------------------------------------------
| This structure holds the three time strings which we're interested
| in for objects.
-----------------------------------------------------------------------*/
typedef struct _kcms_times
{
   kstring  creation;
   kstring  modification;
   kstring  generation;
} kcms_times;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

extern int errno;


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

int	kcms_legal_object		PROTO((kobject,char *));

int	kcms_tb_close			PROTO((kobject));
char *	kcms_tb_info			PROTO((kobject,char *));
int	kcms_tb_destroy			PROTO((kobject));
int	kcms_tb_sync			PROTO((kobject));
kobject	kcms_tb_initialize		PROTO((void));

kobject	kcms_cmobj_duplicate		PROTO((kobject,kobject));
kobject	kcms_cmobj_open			PROTO((kobject,char *));
kobject	kcms_cmobj_partial_open		PROTO((kobject,char *,char *));
kobject	kcms_cmobj_complete_open	PROTO((kobject));
kobject	kcms_cmobj_create		PROTO((kobject,char *,int));
char *	kcms_cmobj_info			PROTO((kobject,char *));
int	kcms_cmobj_partial_close	PROTO((kobject));
int	kcms_cmobj_close		PROTO((kobject));
int	kcms_cmobj_destroy		PROTO((kobject));
void	kcms_cmobj_free_comb_lists	PROTO((kobject));
int	kcms_cmobj_sync			PROTO((kobject));
kbool   kcms_cmobj_rename               PROTO((kobject, kstring));

kobject	kcms_fobj_duplicate		PROTO((kobject,kobject));
char *	kcms_fobj_info			PROTO((kobject,char *));
int	kcms_fobj_destroy		PROTO((kobject));
int	kcms_fobj_pack			PROTO((kobject,char *));
int     kcms_fobj_shift_parent          PROTO((kobject, kstring, kstring,
					       kstring, kstring,
					       kstring, kstring));


void	kcms_init_errors		PROTO((void));

char **	kghost_get_progspec		PROTO((kobject));

char *	kcms_create_toplevel		PROTO((kobject,char *,char *));
char *	kstrip_header			PROTO((char *));

int	kcms_decode_yesno		PROTO((char *));
void	close_n_free			PROTO((klist *));
void	partclose_n_free		PROTO((klist *));
int	kghost_update_file		PROTO((kobject, int));
int	kcms_dir_imakeandmake		PROTO((char *,char *,int));
int	kcms_get_header_info		PROTO((kobject));

void	kcms_sync_header_close		PROTO((void));
void	obj_list_to_string		PROTO((klist *, int, char *));

char *	kcms_env_getpath		PROTO((char *));
char *	kcms_env_getvariable		PROTO((char *));
int	kcms_env_addtb			PROTO((char *, char *));
int	kcms_env_deletetb		PROTO((char *));

int	kcms_cmobj_update_cache		PROTO((kobject));

void    kcms_cmobj_set_pane_title       PROTO((kobject, kstring));

void    kcms_db_open_fileobj            PROTO((kobject, kobject *, kdbm *,
					       kstring, int, int, int, int));
void    kcms_db_read_dates              PROTO((kdbm *, kstring *,
					       kstring *, kstring *));
void    kcms_db_write_dates             PROTO((kdbm *, kstring, kstring,
					       kstring));


#endif /* _kcms_internals_h_ */
/* Don't add after this point */
