/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros clui get interface routines
   >>>>
   >>>>	 Static:
   >>>>  Private:
   >>>>             kclui_get_value()
   >>>>
   >>>>             kclui_get_flag()
   >>>>             kclui_get_int()
   >>>>             kclui_get_long()
   >>>>             kclui_get_short()
   >>>>             kclui_get_float()
   >>>>             kclui_get_double()
   >>>>             kclui_get_string()
   >>>>             kclui_get_infile()
   >>>>             kclui_get_outfile()
   >>>>             kclui_get_logic()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_value - this is a private routine to get
|				       the selection value
|
|       Purpose: This routine gets the selection according to the
|		 specified variable.
|         Input: pane - the pane to search for the variable for
|                variable_name - the name of the variable
|
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
| Modifications:
|
------------------------------------------------------------*/

int kclui_get_value(
   kform *pane,
   char  *variable_name,
   char  *attribute,
   kaddr return_value,
   int   *flag)
{
	kselection   *selection;
	kform_struct *formstruct;
	int	     status = TRUE;

	if (flag) *flag = FALSE;

	/*
	 *  Find the selection, if not then return FALSE for failure
	 */
	if ((selection = kvf_variable_sel_search(pane, variable_name)) == NULL)
	   return(FALSE);

	formstruct = selection->back_kformstruct;

	/*
	 *  Check to see if the variable was specified.
	 */
	if (return_value)
	   status = kvf_get_attribute(formstruct, attribute, return_value);

	if (flag)
	   kvf_get_attribute(formstruct, KVF_MODIFIED, flag);
	return(status);
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_flag - get flag argument
|
|       Purpose: This routines is used to get a flag argument
|		 from a form structure.  The flag is pulled from the
|		 form structure, for the given variable name.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|         Input: pane - the pane to search for the flag
|                name - the name of the flag
|
|        Output: return_flag - the pointer to the flag to be returned
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_flag(
   kform *pane,
   char  *name,
   int   *return_flag)
{
	if (return_flag) *return_flag = FALSE;
	return(kclui_get_value(pane, name, KVF_OPTSEL,
			       (kaddr) return_flag, NULL));
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_int - get int argument
|
|       Purpose: This routines is used to get a int argument
|		 from a form structure.  The int is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the int
|                name - the name of the int
|
|        Output: return_int    - the pointer to the int value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_int(
   kform *pane,
   char  *name,
   int   *return_int,
   int   *flag)
{
	return(kclui_get_value(pane, name, KVF_INT_VAL,
			(kaddr) return_int, flag));
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_long - get long argument
|
|       Purpose: This routines is used to get a long argument
|		 from a form structure.  The long is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the long
|                name - the name of the long
|
|        Output: return_long    - the pointer to the long value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_long(
   kform *pane,
   char  *name,
   long  *return_long,
   int   *flag)
{
	int intval;

	if (kclui_get_value(pane, name, KVF_INT_VAL, (kaddr) &intval, flag))
	   return(FALSE);

	if (return_long)
	   *return_long = intval;

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_short - get short argument
|
|       Purpose: This routines is used to get a short argument
|		 from a form structure.  The short is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the short
|                name - the name of the short
|
|        Output: return_short    - the pointer to the short value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_short(
   kform *pane,
   char  *name,
   short *return_short,
   int   *flag)
{
	int intval;

	if (kclui_get_value(pane, name, KVF_INT_VAL, (kaddr) &intval, flag))
	   return(FALSE);

	if (return_short)
	   *return_short = intval;

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_float - get float argument
|
|       Purpose: This routines is used to get a float argument
|		 from a form structure.  The float is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the float
|                name - the name of the float
|
|        Output: return_float  - the pointer to the float value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_float(
   kform *pane,
   char  *name,
   float *return_float,
   int   *flag)
{
	return(kclui_get_value(pane, name, KVF_FLOAT_VAL,
			(kaddr) return_float, flag));
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_double - get double argument
|
|       Purpose: This routines is used to get a double argument
|		 from a form structure.  The double is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the double
|                name - the name of the double
|
|        Output: return_double - the pointer to the double value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_double(
   kform  *pane,
   char   *name,
   double *return_double,
   int    *flag)
{
	return(kclui_get_value(pane, name, KVF_DOUBLE_VAL,
			(kaddr) return_double, flag));
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_string - get string argument
|
|       Purpose: This routines is used to get a string argument
|		 from a form structure.  The string is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the string
|                name - the name of the string
|
|        Output: return_string - the pointer to the string value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_string(
   kform   *pane,
   char    *name,
   kstring *return_string,
   int     *flag)
{
	return(kclui_get_value(pane, name, KVF_STRING_VAL,
			(kaddr) return_string, flag));
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_infile - get infile argument
|
|       Purpose: This routines is used to get a infile argument
|		 from a form structure.  The infile is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the infile
|                name - the name of the infile
|
|        Output: return_infile - the pointer to the infile value being returned
|                flag - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_infile(
   kform   *pane,
   char    *name,
   kstring *return_infile,
   int     *flag)
{
	if(!kclui_get_value(pane, name, KVF_FILE_NAME,
			(kaddr) return_infile, flag))
	   return(FALSE);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_outfile - get outfile argument
|
|       Purpose: This routines is used to get a outfile argument
|		 from a form structure.  The outfile is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the outfile
|                name - the name of the outfile
|
|        Output: return_outfile - the pointer to the outfile value being
|				  returned
|                flag  - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_outfile(
   kform   *pane,
   char    *name,
   kstring *return_outfile,
   int     *flag)
{
	if (!kclui_get_value(pane, name, KVF_FILE_NAME,
			(kaddr) return_outfile, flag))
	    return(FALSE);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: kclui_get_logical - get logical argument
|
|       Purpose: This routines is used to get a logical argument
|		 from a form structure.  The logical is pulled from the
|		 form structure, for the given variable.  If the
|		 variable is not defined failure is returned and
|		 the errno XXXX is set.
|
|		 The presence flag is used to indicate whether the
|		 argument was acutally specified or the default value
|		 is being passed back.
|
|         Input: pane - the pane to search for the logical
|                name - the name of the logical
|
|        Output: return_logical - the pointer to the logical value being
|				  returned
|                flag  - whether the variable was specified or not
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young & Danielle Argiro
|          Date: Mar 28, 1994
|  Side Effects: 
| Modifications: 
|
------------------------------------------------------------*/

int kclui_get_logical(
   kform *pane,
   char  *name,
   int   *return_logical,
   int   *flag)
{
	return(kclui_get_value(pane, name, KVF_LOGIC_VAL,
			(kaddr) return_logical, flag));
}
