 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            ApolloRPC Transport Drivers
   >>>>
   >>>>  Private:
   >>>>			apollorpc_connect
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "phantomd.h"


#if !defined(KAPOLLORPC_DEF)
RemoteTransport apollorpc_remotetrans[] = {NULL};
#else

/* apollorpc (remote procedure call) transport */
#include <tiuser.h>

static int apollorpc_connect      PROTO((kfile *, char *));

RemoteTransport apollorpc_remotetrans[] =
{
    {
	"Remote Procedure Call (Apollo)",
	"apollorpc",
	FALSE,
	apollorpc_connect,
    }
};

/*
 *  Internal resource structures for "Standard ApolloRPC (AF_UNIX)" transport
 */
typedef struct
{
	int	apollorpc;
} ResourceStruct;



/*-------------------------------------------------------------------*
|  
|		  ApolloRPC Routines
|  
--------------------------------------------------------------------*/

/*-------------------------------------------------------------
|  
|  Routine Name: apollorpc_connect
|  
|       Purpose: This function opens a "apollorpc" connection.  It is an
|	         internal driver to open a apollorpc, which is called by
|	         the the internal apollorpc routines such as apollorpc_open().
|  
|		  	"apollorpc=XXXXXXXXXX"
|  
|  
|         Input:  file - the kfile structure describing the transport
|		  path - the apollorpc path
|          
|        Output:  returns -1 or the apollorpc id
|  
|   Called From:  internal routine called from kopen()
|  
|    Written By:  Mark Young
|          Date:  Jul 08, 1992 16:06
|  
-------------------------------------------------------------*/

/*ARGSUSED*/
static int apollorpc_connect(
   kfile *file,
   char  *path)
{
	return(-1);
}

#endif  /* KAPOLLORPC_DEF */
/* don`t add after the endif */
